/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class NewDriver {
    private static URLClassLoader loader;
    private static String jmDir;

    public static String getJMeterDir() {
        return jmDir;
    }

    private NewDriver(String[] args) {
    }

    public static void main(String[] args) {
        Thread.currentThread().setContextClassLoader(loader);
        if (System.getProperty("log4j.configuration") == null) {
            File conf = new File(jmDir, "bin" + File.separator + "log4j.conf");
            System.setProperty("log4j.configuration", "file:" + conf);
        }
        try {
            Class<?> JMeter = loader.loadClass("org.apache.jmeter.JMeter");
            Object instance = JMeter.newInstance();
            Method startup = JMeter.getMethod("start", new String[0].getClass());
            startup.invoke(instance, new Object[]{args});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        LinkedList<URL> jars = new LinkedList<URL>();
        String cp = System.getProperty("java.class.path");
        StringTokenizer tok = new StringTokenizer(cp, File.pathSeparator);
        if (tok.countTokens() == 1) {
            File jar = new File(tok.nextToken());
            try {
                jmDir = jar.getCanonicalFile().getParentFile().getParent();
            }
            catch (IOException e) {}
        } else {
            File userDir = new File(System.getProperty("user.dir"));
            jmDir = userDir.getAbsoluteFile().getParent();
        }
        StringBuffer classpath = new StringBuffer();
        File[] libDirs = new File[]{new File(jmDir + File.separator + "lib"), new File(jmDir + File.separator + "lib" + File.separator + "ext")};
        int a = 0;
        while (a < libDirs.length) {
            File[] libJars = libDirs[a].listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            int i = 0;
            while (i < libJars.length) {
                try {
                    jars.add(new URL("file", "", libJars[i].getPath()));
                    classpath.append(System.getProperty("path.separator"));
                    classpath.append(libJars[i].getPath());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            ++a;
        }
        System.setProperty("java.class.path", System.getProperty("java.class.path") + classpath.toString());
        loader = new URLClassLoader(jars.toArray(new URL[0]));
    }
}

