/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource;

import com.informix.jdbcx.IfxConnectionPoolDataSource;
import com.informix.jdbcx.IfxDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.log.Logger;

public class InformixDataSource
extends AbstractLogEnabled
implements DataSourceComponent,
Loggable {
    private IfxDataSource m_dataSource;
    private boolean m_autocommit;
    private static boolean INIT_FACTORY = false;

    public InformixDataSource() {
        if (!INIT_FACTORY) {
            System.setProperty("java.naming.factory.initial", "org.apache.avalon.excalibur.naming.memory.MemoryInitialContextFactory");
        }
    }

    public void setLogger(Logger logger) {
        this.enableLogging((org.apache.avalon.framework.logger.Logger)new LogKitLogger(logger));
    }

    public Connection getConnection() throws SQLException {
        Connection conn = this.m_dataSource.getConnection();
        if (conn.getAutoCommit() != this.m_autocommit) {
            conn.setAutoCommit(this.m_autocommit);
        }
        return conn;
    }

    public void configure(Configuration conf) throws ConfigurationException {
        Configuration poolController = conf.getChild("pool-controller");
        String dbname = conf.getChild("dbname").getValue("ifx");
        IfxConnectionPoolDataSource pooledDataSource = new IfxConnectionPoolDataSource();
        this.m_autocommit = conf.getChild("autocommit").getValueAsBoolean(true);
        pooledDataSource.setIfxCPMInitPoolSize(poolController.getAttributeAsInteger("init", 5));
        pooledDataSource.setIfxCPMMinPoolSize(poolController.getAttributeAsInteger("min", 5));
        pooledDataSource.setIfxCPMMaxPoolSize(poolController.getAttributeAsInteger("max", 10));
        pooledDataSource.setIfxCPMServiceInterval(100L);
        pooledDataSource.setServerName(conf.getChild("servername").getValue());
        pooledDataSource.setDatabaseName(conf.getChild("dbname").getValue());
        pooledDataSource.setIfxIFXHOST(conf.getChild("host").getValue());
        pooledDataSource.setPortNumber(conf.getChild("host").getAttributeAsInteger("port"));
        pooledDataSource.setUser(conf.getChild("user").getValue());
        pooledDataSource.setPassword(conf.getChild("password").getValue());
        try {
            InitialContext context = new InitialContext();
            context.bind(dbname + "pool", (Object)pooledDataSource);
            this.m_dataSource = new IfxDataSource();
            this.m_dataSource.setDataSourceName(dbname + "pool");
            this.m_dataSource.setServerName(conf.getChild("servername").getValue());
            this.m_dataSource.setDatabaseName(conf.getChild("dbname").getValue());
            this.m_dataSource.setIfxIFXHOST(conf.getChild("host").getValue());
            this.m_dataSource.setPortNumber(conf.getChild("host").getAttributeAsInteger("port"));
            this.m_dataSource.setUser(conf.getChild("user").getValue());
            this.m_dataSource.setPassword(conf.getChild("password").getValue());
            context.bind(dbname, (Object)this.m_dataSource);
        }
        catch (Exception e) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("There was an error trying to bind the connection pool", (Throwable)e);
            }
            throw new ConfigurationException("There was an error trying to bind the connection pool", (Throwable)e);
        }
    }
}

