/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.oro.text.MalformedCachePatternException;
import org.apache.oro.text.PatternCacheLRU;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class ResponseAssertion
extends AbstractTestElement
implements Serializable,
Assertion {
    public static final String TEST_FIELD = "Assertion.test_field";
    public static final String TEST_TYPE = "Assertion.test_type";
    public static final String TEST_STRINGS = "Asserion.test_strings";
    public static final String SAMPLE_LABEL = "Assertion.sample_label";
    public static final String RESPONSE_DATA = "Assertion.response_data";
    private String notMessage = "";
    private String failMessage = "to contain: ";
    public static final int MATCH = 1;
    public static final int CONTAINS = 2;
    public static final int NOT = 4;
    private static ThreadLocal matcher;
    private static PatternCacheLRU patternCache;

    public ResponseAssertion() {
        this.setProperty(TEST_STRINGS, new ArrayList());
    }

    public ResponseAssertion(String field, int type, String string) {
        this();
        this.setTestField(field);
        this.setTestType(type);
        this.getTestStrings().add(string);
    }

    public void setTestField(String testField) {
        this.setProperty(TEST_FIELD, testField);
    }

    public void setTestType(int testType) {
        this.setProperty(TEST_TYPE, new Integer(testType));
        this.notMessage = (testType & 4) > 0 ? "not " : "";
        this.failMessage = (testType & 2) > 0 ? "to contain: " : "to match: ";
    }

    public void addTestString(String testString) {
        this.getTestStrings().add(testString);
    }

    public void setTestString(String testString, int index) {
        this.getTestStrings().set(index, testString);
    }

    public void removeTestString(String testString) {
        this.getTestStrings().remove(testString);
    }

    public void removeTestString(int index) {
        this.getTestStrings().remove(index);
    }

    public void clearTestStrings() {
        this.getTestStrings().clear();
    }

    public AssertionResult getResult(SampleResult response) {
        if (!response.isSuccessful()) {
            AssertionResult result = new AssertionResult();
            result.setError(true);
            result.setFailureMessage(new String(response.getResponseData()));
            return result;
        }
        AssertionResult result = this.evaluateResponse(response);
        return result;
    }

    public String getTestField() {
        return (String)this.getProperty(TEST_FIELD);
    }

    public int getTestType() {
        Object type = this.getProperty(TEST_TYPE);
        if (type == null) {
            return 2;
        }
        if (type instanceof Integer) {
            return (Integer)type;
        }
        return Integer.parseInt((String)type);
    }

    public List getTestStrings() {
        return (List)this.getProperty(TEST_STRINGS);
    }

    public boolean isContainsType() {
        return (this.getTestType() & 2) > 0;
    }

    public boolean isMatchType() {
        return (this.getTestType() & 1) > 0;
    }

    public boolean isNotType() {
        return (this.getTestType() & 4) > 0;
    }

    public void setToContainsType() {
        this.setTestType((this.getTestType() | 2) & 6);
        this.failMessage = "to contain: ";
    }

    public void setToMatchType() {
        this.setTestType((this.getTestType() | 1) & 5);
        this.failMessage = "to match: ";
    }

    public void setToNotType() {
        this.setTestType(this.getTestType() | 4);
    }

    public void unsetNotType() {
        this.setTestType(this.getTestType() & 3);
    }

    private AssertionResult evaluateResponse(SampleResult response) {
        boolean pass = true;
        boolean not = (4 & this.getTestType()) > 0;
        AssertionResult result = new AssertionResult();
        String responseString = new String(response.getResponseData());
        try {
            Perl5Matcher localMatcher = (Perl5Matcher)matcher.get();
            Iterator iter = this.getTestStrings().iterator();
            while (iter.hasNext()) {
                String stringPattern = (String)iter.next();
                Pattern pattern = patternCache.getPattern(stringPattern, 32768);
                boolean found = (2 & this.getTestType()) > 0 ? localMatcher.contains(responseString, pattern) : localMatcher.matches(responseString, pattern);
                boolean bl = not ? !found : (pass = found);
                if (pass) continue;
                result.setFailure(true);
                result.setFailureMessage("Test Failed, expected " + this.notMessage + this.failMessage + stringPattern);
                break;
            }
            if (pass) {
                result.setFailure(false);
            }
            result.setError(false);
        }
        catch (MalformedCachePatternException e) {
            result.setError(true);
            result.setFailure(false);
            result.setFailureMessage("Bad test configuration" + (Object)((Object)e));
        }
        return result;
    }

    static {
        TEST_FIELD = TEST_FIELD;
        TEST_TYPE = TEST_TYPE;
        TEST_STRINGS = TEST_STRINGS;
        SAMPLE_LABEL = SAMPLE_LABEL;
        RESPONSE_DATA = RESPONSE_DATA;
        MATCH = 1;
        CONTAINS = 2;
        NOT = 4;
        matcher = new ThreadLocal(){

            protected Object initialValue() {
                return new Perl5Matcher();
            }
        };
        patternCache = new PatternCacheLRU(1000, (PatternCompiler)new Perl5Compiler());
    }

    public static class Test
    extends TestCase {
        int threadsRunning;
        int failed;

        public Test(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void testThreadSafety() throws Exception {
            Thread[] threads = new Thread[100];
            int i = 0;
            while (i < threads.length) {
                threads[i] = new TestThread();
                ++i;
            }
            this.failed = 0;
            int i2 = 0;
            while (i2 < threads.length) {
                threads[i2].start();
                ++this.threadsRunning;
                ++i2;
            }
            Test test = this;
            synchronized (test) {
                while (this.threadsRunning > 0) {
                    ((Object)((Object)this)).wait();
                }
            }
            Assert.assertEquals((int)this.failed, (int)0);
        }

        class TestThread
        extends Thread {
            static final String TEST_STRING = "D\u00e1bale arroz a la zorra el abad.";
            static final String TEST_PATTERN = ".*\u00e1.*\\.";

            TestThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ResponseAssertion assertion = new ResponseAssertion(ResponseAssertion.RESPONSE_DATA, 2, TEST_PATTERN);
                SampleResult response = new SampleResult();
                response.setResponseData(TEST_STRING.getBytes());
                int i = 0;
                while (i < 100) {
                    AssertionResult result = assertion.evaluateResponse(response);
                    if (result.isFailure() || result.isError()) {
                        ++Test.this.failed;
                    }
                    ++i;
                }
                Test test = Test.this;
                synchronized (test) {
                    --Test.this.threadsRunning;
                    ((Object)((Object)Test.this)).notify();
                }
            }

            static {
                TEST_STRING = TEST_STRING;
                TEST_PATTERN = TEST_PATTERN;
            }
        }
    }
}

