/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import java.io.Serializable;
import java.text.MessageFormat;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.util.JMeterUtils;

public class SizeAssertion
extends AbstractTestElement
implements Serializable,
Assertion {
    int comparator = 1;
    String comparatorErrorMessage = "ERROR!";
    public static final int EQUAL = 1;
    public static final int NOTEQUAL = 2;
    public static final int GREATERTHAN = 3;
    public static final int LESSTHAN = 4;
    public static final int GREATERTHANEQUAL = 5;
    public static final int LESSTHANEQUAL = 6;
    private static final String SIZE_KEY = "SizeAssertion.size";
    byte[] resultData;

    public AssertionResult getResult(SampleResult response) {
        AssertionResult result = new AssertionResult();
        result.setFailure(false);
        this.resultData = this.getResultBody(response.getResponseData());
        long resultSize = this.resultData.length;
        if (!this.compareSize(resultSize) && this.getAllowedSize() > 0L) {
            result.setFailure(true);
            Object[] arguments = new Object[]{new Long(resultSize), new String(this.comparatorErrorMessage), new Long(this.getAllowedSize())};
            String message = MessageFormat.format(JMeterUtils.getResString((String)"size_assertion_failure"), arguments);
            result.setFailureMessage(message);
        }
        return result;
    }

    public long getAllowedSize() {
        return this.getPropertyAsLong(SIZE_KEY);
    }

    public void setAllowedSize(long size) throws IllegalArgumentException {
        if (size < 0L) {
            throw new IllegalArgumentException(JMeterUtils.getResString((String)"argument_must_not_be_negative"));
        }
        if (size == Long.MAX_VALUE) {
            this.setProperty(SIZE_KEY, new Long(0L));
        } else {
            this.setProperty(SIZE_KEY, new Long(size));
        }
    }

    private byte[] getResultBody(byte[] resultData) {
        int i = 0;
        while (i < resultData.length - 1) {
            if (resultData[i] == 10 && resultData[i + 1] == 10) {
                return this.getByteArraySlice(resultData, i + 3, resultData.length);
            }
            ++i;
        }
        return resultData;
    }

    private byte[] getByteArraySlice(byte[] array, int begin, int end) {
        byte[] slice = new byte[end - begin + 1];
        int count = 0;
        int i = begin;
        while (i < end) {
            slice[count] = array[i];
            ++count;
            ++i;
        }
        return slice;
    }

    public void setLogicalComparator(int comparator) {
        this.comparator = comparator;
    }

    private boolean compareSize(long resultSize) {
        boolean result = false;
        switch (this.comparator) {
            case 1: {
                result = resultSize == this.getAllowedSize();
                this.comparatorErrorMessage = JMeterUtils.getResString((String)"size_assertion_comparator_error_equal");
                break;
            }
            case 2: {
                result = resultSize != this.getAllowedSize();
                this.comparatorErrorMessage = JMeterUtils.getResString((String)"size_assertion_comparator_error_notequal");
                break;
            }
            case 3: {
                result = resultSize > this.getAllowedSize();
                this.comparatorErrorMessage = JMeterUtils.getResString((String)"size_assertion_comparator_error_greater");
                break;
            }
            case 4: {
                result = resultSize < this.getAllowedSize();
                this.comparatorErrorMessage = JMeterUtils.getResString((String)"size_assertion_comparator_error_less");
                break;
            }
            case 5: {
                result = resultSize >= this.getAllowedSize();
                this.comparatorErrorMessage = JMeterUtils.getResString((String)"size_assertion_comparator_error_greaterequal");
                break;
            }
            case 6: {
                result = resultSize <= this.getAllowedSize();
                this.comparatorErrorMessage = JMeterUtils.getResString((String)"size_assertion_comparator_error_lessequal");
            }
        }
        return result;
    }

    static {
        EQUAL = 1;
        NOTEQUAL = 2;
        GREATERTHAN = 3;
        LESSTHAN = 4;
        GREATERTHANEQUAL = 5;
        LESSTHANEQUAL = 6;
        SIZE_KEY = SIZE_KEY;
    }
}

