/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.jmeter.assertions.ResponseAssertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.gui.util.TextAreaCellRenderer;
import org.apache.jmeter.gui.util.TextAreaTableCellEditor;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class AssertionGui
extends AbstractAssertionGui
implements FocusListener {
    static final String COL_NAME = JMeterUtils.getResString((String)"assertion_patterns_to_test");
    private JRadioButton responseStringButton;
    private JRadioButton labelButton;
    private JRadioButton containsBox;
    private JRadioButton matchesBox;
    private JCheckBox notBox;
    private JTable stringTable;
    private JButton addPattern;
    private JButton deletePattern;
    PowerTableModel tableModel;
    static /* synthetic */ Class class$java$lang$String;

    public AssertionGui() {
        this.init();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"assertion_title");
    }

    public TestElement createTestElement() {
        ResponseAssertion el = new ResponseAssertion();
        String[] testStrings = this.tableModel.getData().getColumn(COL_NAME);
        int i = 0;
        while (i < testStrings.length) {
            el.addTestString(testStrings[i]);
            ++i;
        }
        this.configureTestElement((TestElement)el);
        if (this.labelButton.isSelected()) {
            el.setTestField("Assertion.sample_label");
        } else {
            el.setTestField("Assertion.response_data");
        }
        if (this.containsBox.isSelected()) {
            el.setToContainsType();
        } else {
            el.setToMatchType();
        }
        if (this.notBox.isSelected()) {
            el.setToNotType();
        } else {
            el.unsetNotType();
        }
        return el;
    }

    public void configure(TestElement el) {
        super.configure(el);
        ResponseAssertion model = (ResponseAssertion)el;
        if (model.isContainsType()) {
            this.containsBox.setSelected(true);
            this.matchesBox.setSelected(false);
        } else {
            this.containsBox.setSelected(false);
            this.matchesBox.setSelected(true);
        }
        if (model.isNotType()) {
            this.notBox.setSelected(true);
        } else {
            this.notBox.setSelected(false);
        }
        if ("Assertion.response_data".equals(model.getTestField())) {
            this.responseStringButton.setSelected(true);
            this.labelButton.setSelected(false);
        } else {
            this.responseStringButton.setSelected(false);
            this.labelButton.setSelected(true);
        }
        Iterator tests = model.getTestStrings().iterator();
        while (tests.hasNext()) {
            this.tableModel.addRow(new Object[]{tests.next()});
        }
        this.tableModel.fireTableDataChanged();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        JPanel mainPanel = new JPanel();
        this.add(mainPanel, gbc.clone());
        gbc.weighty = 0.0;
        mainPanel.setLayout(new GridBagLayout());
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        JLabel panelTitleLabel = new JLabel(JMeterUtils.getResString((String)"assertion_title"));
        Font curFont = panelTitleLabel.getFont();
        int curFontSize = curFont.getSize();
        panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
        mainPanel.add((Component)panelTitleLabel, gbc.clone());
        ++gbc.gridy;
        mainPanel.add((Component)this.getNamePanel(), gbc.clone());
        ++gbc.gridx;
        mainPanel.add(Box.createHorizontalGlue(), gbc.clone());
        --gbc.gridx;
        ++gbc.gridy;
        mainPanel.add((Component)this.createFieldPanel(), gbc.clone());
        ++gbc.gridy;
        mainPanel.add((Component)this.createTypePanel(), gbc.clone());
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        mainPanel.add((Component)this.createStringPanel(), gbc.clone());
    }

    private JPanel createFieldPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"assertion_resp_field")));
        this.responseStringButton = new JRadioButton(JMeterUtils.getResString((String)"assertion_text_resp"));
        this.labelButton = new JRadioButton(JMeterUtils.getResString((String)"assertion_url_samp"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.responseStringButton);
        group.add(this.labelButton);
        panel.add(this.responseStringButton);
        panel.add(this.labelButton);
        this.responseStringButton.setSelected(true);
        return panel;
    }

    private JPanel createTypePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"assertion_pattern_match_rules")));
        this.containsBox = new JRadioButton(JMeterUtils.getResString((String)"assertion_contains"));
        this.matchesBox = new JRadioButton(JMeterUtils.getResString((String)"assertion_matches"));
        this.notBox = new JCheckBox(JMeterUtils.getResString((String)"assertion_not"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.matchesBox);
        group.add(this.containsBox);
        panel.add(this.containsBox);
        panel.add(this.matchesBox);
        panel.add(this.notBox);
        this.containsBox.setSelected(true);
        return panel;
    }

    public void focusLost(FocusEvent e) {
        try {
            this.stringTable.getCellEditor().stopCellEditing();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void focusGained(FocusEvent e) {
    }

    private JPanel createStringPanel() {
        JPanel panel = new JPanel();
        this.stringTable = new JTable(0, 1);
        this.stringTable.addFocusListener(this);
        this.tableModel = new PowerTableModel(new String[]{COL_NAME}, new Class[]{class$java$lang$String == null ? (class$java$lang$String = AssertionGui.class$("java.lang.String")) : class$java$lang$String});
        this.stringTable.setModel((TableModel)this.tableModel);
        TextAreaCellRenderer renderer = new TextAreaCellRenderer();
        this.stringTable.setDefaultEditor(class$java$lang$String == null ? (class$java$lang$String = AssertionGui.class$("java.lang.String")) : class$java$lang$String, (TableCellEditor)new TextAreaTableCellEditor());
        this.stringTable.setRowHeight(renderer.getPreferredHeight());
        this.stringTable.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = AssertionGui.class$("java.lang.String")) : class$java$lang$String, (TableCellRenderer)renderer);
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"assertion_patterns_to_test")));
        panel.add((Component)new JScrollPane(this.stringTable), "Center");
        this.addPattern = new JButton(JMeterUtils.getResString((String)"add"));
        this.deletePattern = new JButton(JMeterUtils.getResString((String)"delete"));
        this.addPattern.addActionListener(new AddPatternListener());
        this.deletePattern.addActionListener(new ClearPatternsListener());
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.addPattern);
        buttonPanel.add(this.deletePattern);
        panel.add((Component)buttonPanel, "South");
        this.deletePattern.setEnabled(false);
        return panel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PatternRenderer
    extends DefaultListCellRenderer {
        private PatternRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String displayText = value.toString();
            if (displayText.length() > 10) {
                displayText = displayText.substring(0, 10);
            }
            JLabel label = new JLabel(displayText);
            if (isSelected) {
                label.setBackground(Color.blue);
                label.setForeground(Color.white);
                label.setOpaque(true);
            } else {
                label.setForeground(Color.black);
                label.setBackground(Color.white);
            }
            if (cellHasFocus) {
                label.setBorder(BorderFactory.createEtchedBorder());
            }
            label.setText(displayText);
            return label;
        }
    }

    private class AddPatternListener
    implements ActionListener {
        private AddPatternListener() {
        }

        public void actionPerformed(ActionEvent e) {
            AssertionGui.this.tableModel.addNewRow();
            AssertionGui.this.deletePattern.setEnabled(true);
            AssertionGui.this.tableModel.fireTableDataChanged();
        }
    }

    private class ClearPatternsListener
    implements ActionListener {
        private ClearPatternsListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int index = AssertionGui.this.stringTable.getSelectedRow();
            AssertionGui.this.stringTable.getCellEditor(index, AssertionGui.this.stringTable.getSelectedColumn()).cancelCellEditing();
            if (index > -1) {
                AssertionGui.this.tableModel.removeRow(index);
                AssertionGui.this.tableModel.fireTableDataChanged();
            }
            if (AssertionGui.this.stringTable.getModel().getRowCount() == 0) {
                AssertionGui.this.deletePattern.setEnabled(false);
            }
        }
    }
}

