/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.assertions.DurationAssertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class DurationAssertionGui
extends AbstractAssertionGui
implements FocusListener {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.elements");
    private JTextField duration;

    public DurationAssertionGui() {
        this.init();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"duration_assertion_title");
    }

    public String getDurationAttributesTitle() {
        return JMeterUtils.getResString((String)"duration_assertion_duration_test");
    }

    public TestElement createTestElement() {
        DurationAssertion el = new DurationAssertion();
        this.configureTestElement((TestElement)el);
        String durationString = this.duration.getText();
        long assertionDuration = 0L;
        try {
            assertionDuration = Long.parseLong(durationString);
        }
        catch (NumberFormatException e) {
            assertionDuration = Long.MAX_VALUE;
        }
        el.setAllowedDuration(assertionDuration);
        return el;
    }

    public void configure(TestElement el) {
        super.configure(el);
        DurationAssertion assertion = (DurationAssertion)el;
        this.duration.setText(String.valueOf(assertion.getAllowedDuration()));
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 2, 1));
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
        JLabel panelTitleLabel = new JLabel(this.getStaticLabel());
        Font curFont = panelTitleLabel.getFont();
        int curFontSize = curFont.getSize();
        panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
        mainPanel.add(panelTitleLabel);
        mainPanel.add((Component)this.getNamePanel());
        JPanel durationPanel = new JPanel();
        durationPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.getDurationAttributesTitle()));
        FlowLayout layout = new FlowLayout();
        durationPanel.setLayout(layout);
        durationPanel.add(new JLabel(JMeterUtils.getResString((String)"duration_assertion_label")));
        this.duration = new JTextField(5);
        this.duration.addFocusListener(this);
        durationPanel.add(this.duration);
        mainPanel.add(durationPanel);
        this.add(mainPanel);
    }

    public void focusLost(FocusEvent e) {
        boolean isInvalid = false;
        String durationString = this.duration.getText();
        if (durationString != null) {
            try {
                long assertionDuration = Long.parseLong(durationString);
                if (assertionDuration < 0L) {
                    isInvalid = true;
                }
            }
            catch (NumberFormatException ex) {
                isInvalid = true;
            }
            if (isInvalid) {
                log.warn("DurationAssertionGui: Not a valid number!");
                JOptionPane.showMessageDialog(null, JMeterUtils.getResString((String)"duration_assertion_input_error"), "Error", 0);
            }
        }
    }

    public void focusGained(FocusEvent e) {
    }
}

