/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.assertions.SizeAssertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class SizeAssertionGui
extends AbstractAssertionGui
implements FocusListener,
ActionListener {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.elements");
    private JTextField size;
    SizeAssertion sa = new SizeAssertion();

    public SizeAssertionGui() {
        this.init();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"size_assertion_title");
    }

    public String getSizeAttributesTitle() {
        return JMeterUtils.getResString((String)"size_assertion_size_test");
    }

    public TestElement createTestElement() {
        SizeAssertion el = new SizeAssertion();
        this.configureTestElement((TestElement)el);
        String sizeString = this.size.getText();
        long assertionSize = 0L;
        try {
            assertionSize = Long.parseLong(sizeString);
        }
        catch (NumberFormatException e) {
            assertionSize = Long.MAX_VALUE;
        }
        el.setAllowedSize(assertionSize);
        return el;
    }

    public void configure(TestElement el) {
        super.configure(el);
        SizeAssertion assertion = (SizeAssertion)el;
        this.size.setText(String.valueOf(assertion.getAllowedSize()));
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 2, 1));
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
        JLabel panelTitleLabel = new JLabel(this.getStaticLabel());
        Font curFont = panelTitleLabel.getFont();
        int curFontSize = curFont.getSize();
        panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
        mainPanel.add(panelTitleLabel);
        mainPanel.add((Component)this.getNamePanel());
        JPanel sizePanel = new JPanel();
        sizePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.getSizeAttributesTitle()));
        FlowLayout layout = new FlowLayout();
        sizePanel.setLayout(layout);
        sizePanel.add(new JLabel(JMeterUtils.getResString((String)"size_assertion_label")));
        this.size = new JTextField(5);
        this.size.addFocusListener(this);
        sizePanel.add(this.size);
        ButtonGroup comparatorButtonGroup = new ButtonGroup();
        JRadioButton equalButton = new JRadioButton("=");
        equalButton.setSelected(true);
        equalButton.setActionCommand(new Integer(1).toString());
        equalButton.addActionListener(this);
        comparatorButtonGroup.add(equalButton);
        JRadioButton notequalButton = new JRadioButton("!=");
        notequalButton.setActionCommand(new Integer(2).toString());
        notequalButton.addActionListener(this);
        comparatorButtonGroup.add(notequalButton);
        JRadioButton greaterthanButton = new JRadioButton(">");
        greaterthanButton.setActionCommand(new Integer(3).toString());
        greaterthanButton.addActionListener(this);
        comparatorButtonGroup.add(greaterthanButton);
        JRadioButton lessthanButton = new JRadioButton("<");
        lessthanButton.setActionCommand(new Integer(4).toString());
        lessthanButton.addActionListener(this);
        comparatorButtonGroup.add(lessthanButton);
        JRadioButton greaterthanequalButton = new JRadioButton(">=");
        greaterthanequalButton.setActionCommand(new Integer(5).toString());
        greaterthanequalButton.addActionListener(this);
        comparatorButtonGroup.add(greaterthanequalButton);
        JRadioButton lessthanequalButton = new JRadioButton("<=");
        lessthanequalButton.setActionCommand(new Integer(6).toString());
        lessthanequalButton.addActionListener(this);
        comparatorButtonGroup.add(lessthanequalButton);
        JPanel checkPanel = new JPanel();
        checkPanel.setLayout(new GridLayout(0, 1));
        JLabel compareLabel = new JLabel(JMeterUtils.getResString((String)"size_assertion_comparator_label"));
        checkPanel.add(compareLabel);
        checkPanel.add(equalButton);
        checkPanel.add(notequalButton);
        checkPanel.add(greaterthanButton);
        checkPanel.add(lessthanButton);
        checkPanel.add(greaterthanequalButton);
        checkPanel.add(lessthanequalButton);
        sizePanel.add(checkPanel);
        mainPanel.add(sizePanel);
        this.add(mainPanel);
    }

    public void focusLost(FocusEvent e) {
        boolean isInvalid = false;
        String sizeString = this.size.getText();
        if (sizeString != null) {
            try {
                long assertionSize = Long.parseLong(sizeString);
                if (assertionSize < 0L) {
                    isInvalid = true;
                }
            }
            catch (NumberFormatException ex) {
                isInvalid = true;
            }
            if (isInvalid) {
                log.warn("SizeAssertionGui: Not a valid number!");
                JOptionPane.showMessageDialog(null, JMeterUtils.getResString((String)"size_assertion_input_error"), "Error", 0);
            }
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        int comparator = new Integer(e.getActionCommand());
        this.sa.setLogicalComparator(comparator);
    }
}

