/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestElement;

public class InterleaveControl
extends GenericController
implements Serializable {
    private static final String STYLE = "InterleaveControl.style";
    public static final int DEFAULT_STYLE = 0;
    public static final int NEW_STYLE = 1;
    private boolean interleave;
    private boolean doNotIncrement = false;

    public void initialize() {
        super.initialize();
        this.interleave = false;
    }

    public void reInitialize() {
        super.initialize();
        this.interleave = false;
    }

    public boolean hasNext() {
        boolean retVal;
        TestElement controller = this.getCurrentController();
        if (controller == null) {
            retVal = this.hasNextAtEnd();
        } else if (controller instanceof Controller) {
            if (((Controller)controller).hasNext()) {
                retVal = true;
            } else {
                this.currentHasNextIsFalse();
                retVal = this.hasNext();
            }
        } else {
            retVal = true;
        }
        if (controller == null) {
            this.reInitialize();
        }
        if (this.interleave) {
            this.interleave = false;
            return false;
        }
        return retVal;
    }

    protected void removeCurrentController() {
        this.setInterleave(1);
        super.removeCurrentController();
    }

    protected void incrementCurrent() {
        this.setInterleave(1);
        super.incrementCurrent();
    }

    protected void setInterleave(int style) {
        if (this.getStyle() == style) {
            this.interleave = true;
        }
    }

    public void setStyle(int style) {
        this.setProperty(STYLE, new Integer(style));
    }

    public int getStyle() {
        return this.getPropertyAsInt(STYLE);
    }

    public Sampler next() {
        this.setInterleave(0);
        TestElement controller = this.getCurrentController();
        if (controller == null) {
            this.nextAtEnd();
            return this.next();
        }
        if (controller instanceof Sampler) {
            this.incrementCurrent();
            return (Sampler)controller;
        }
        Controller c = (Controller)controller;
        if (c.hasNext()) {
            Sampler s = c.next();
            if (this.getStyle() == 0) {
                this.incrementCurrent();
            }
            return s;
        }
        if (c.isDone()) {
            this.removeCurrentController();
            return this.next();
        }
        this.incrementCurrent();
        return this.next();
    }

    static {
        STYLE = STYLE;
        DEFAULT_STYLE = 0;
        NEW_STYLE = 1;
    }

    public static class Test
    extends TestCase {
        public Test(String name) {
            super(name);
        }

        public void testProcessing() throws Exception {
            GenericController controller = new GenericController();
            InterleaveControl sub_1 = new InterleaveControl();
            sub_1.setStyle(0);
            sub_1.addTestElement(this.makeSampler("one"));
            sub_1.addTestElement(this.makeSampler("two"));
            controller.addTestElement((TestElement)sub_1);
            controller.addTestElement(this.makeSampler("three"));
            LoopController sub_2 = new LoopController();
            sub_2.setLoops(3);
            GenericController sub_3 = new GenericController();
            sub_2.addTestElement(this.makeSampler("four"));
            sub_3.addTestElement(this.makeSampler("five"));
            sub_3.addTestElement(this.makeSampler("six"));
            sub_2.addTestElement((TestElement)sub_3);
            sub_2.addTestElement(this.makeSampler("seven"));
            controller.addTestElement((TestElement)sub_2);
            String[] interleaveOrder = new String[]{"one", "two"};
            String[] order = new String[]{"dummy", "three", "four", "five", "six", "seven", "four", "five", "six", "seven", "four", "five", "six", "seven"};
            int counter = 14;
            int i = 0;
            while (i < 4) {
                Assert.assertEquals((int)14, (int)counter);
                counter = 0;
                while (controller.hasNext()) {
                    Sampler sampler = controller.next();
                    if (counter == 0) {
                        Assert.assertEquals((Object)interleaveOrder[i % 2], (Object)sampler.getProperty("TestElement.name"));
                    } else {
                        Assert.assertEquals((Object)order[counter], (Object)sampler.getProperty("TestElement.name"));
                    }
                    ++counter;
                }
                ++i;
            }
        }

        /*
         * Unable to fully structure code
         */
        public void testProcessing2() throws Exception {
            controller = new GenericController();
            sub_1 = new InterleaveControl();
            sub_1.setStyle(0);
            sub_1.addTestElement(this.makeSampler("one"));
            sub_1.addTestElement(this.makeSampler("two"));
            controller.addTestElement((TestElement)sub_1);
            controller.addTestElement(this.makeSampler("three"));
            sub_2 = new LoopController();
            sub_2.setLoops(3);
            sub_3 = new GenericController();
            sub_2.addTestElement(this.makeSampler("four"));
            sub_3.addTestElement(this.makeSampler("five"));
            sub_3.addTestElement(this.makeSampler("six"));
            sub_2.addTestElement((TestElement)sub_3);
            sub_2.addTestElement(this.makeSampler("seven"));
            sub_1.addTestElement((TestElement)sub_2);
            order = new String[]{"one", "three", "two", "three", "four", "three", "one", "three", "two", "three", "five", "three", "one", "three", "two", "three", "six", "three", "one", "three"};
            counter = 0;
            ** GOTO lbl25
            {
                sampler = controller.next();
                Assert.assertEquals((String)("failed on " + counter), (Object)order[counter], (Object)sampler.getProperty("TestElement.name"));
                ++counter;
                do {
                    if (controller.hasNext()) continue block0;
lbl25:
                    // 2 sources

                } while (counter < order.length);
            }
        }

        /*
         * Unable to fully structure code
         */
        public void testProcessing3() throws Exception {
            controller = new GenericController();
            sub_1 = new InterleaveControl();
            sub_1.setStyle(1);
            sub_1.addTestElement(this.makeSampler("one"));
            sub_1.addTestElement(this.makeSampler("two"));
            controller.addTestElement((TestElement)sub_1);
            controller.addTestElement(this.makeSampler("three"));
            sub_2 = new LoopController();
            sub_2.setLoops(3);
            sub_3 = new GenericController();
            sub_2.addTestElement(this.makeSampler("four"));
            sub_3.addTestElement(this.makeSampler("five"));
            sub_3.addTestElement(this.makeSampler("six"));
            sub_2.addTestElement((TestElement)sub_3);
            sub_2.addTestElement(this.makeSampler("seven"));
            sub_1.addTestElement((TestElement)sub_2);
            order = new String[]{"one", "three", "two", "three", "four", "five", "six", "seven", "four", "five", "six", "seven", "four", "five", "six", "seven", "three", "one", "three", "two", "three"};
            counter = 0;
            ** GOTO lbl25
            {
                sampler = controller.next();
                Assert.assertEquals((String)("failed on " + counter), (Object)order[counter], (Object)sampler.getProperty("TestElement.name"));
                ++counter;
                do {
                    if (controller.hasNext()) continue block0;
lbl25:
                    // 2 sources

                } while (counter < order.length);
            }
        }

        /*
         * Unable to fully structure code
         */
        public void testProcessing4() throws Exception {
            controller = new GenericController();
            sub_1 = new InterleaveControl();
            sub_1.setStyle(0);
            controller.addTestElement((TestElement)sub_1);
            sub_2 = new GenericController();
            sub_2.addTestElement(this.makeSampler("one"));
            sub_2.addTestElement(this.makeSampler("two"));
            sub_1.addTestElement((TestElement)sub_2);
            sub_3 = new GenericController();
            sub_3.addTestElement(this.makeSampler("three"));
            sub_3.addTestElement(this.makeSampler("four"));
            sub_1.addTestElement((TestElement)sub_3);
            order = new String[]{"one", "three", "two", "four"};
            counter = 0;
            ** GOTO lbl21
            {
                sampler = controller.next();
                Assert.assertEquals((String)("failed on " + counter), (Object)order[counter], (Object)sampler.getProperty("TestElement.name"));
                ++counter;
                do {
                    if (controller.hasNext()) continue block0;
lbl21:
                    // 2 sources

                } while (counter < order.length);
            }
        }

        /*
         * Unable to fully structure code
         */
        public void testProcessing5() throws Exception {
            controller = new GenericController();
            sub_1 = new InterleaveControl();
            sub_1.setStyle(1);
            controller.addTestElement((TestElement)sub_1);
            sub_2 = new GenericController();
            sub_2.addTestElement(this.makeSampler("one"));
            sub_2.addTestElement(this.makeSampler("two"));
            sub_1.addTestElement((TestElement)sub_2);
            sub_3 = new GenericController();
            sub_3.addTestElement(this.makeSampler("three"));
            sub_3.addTestElement(this.makeSampler("four"));
            sub_1.addTestElement((TestElement)sub_3);
            order = new String[]{"one", "two", "three", "four"};
            counter = 0;
            ** GOTO lbl21
            {
                sampler = controller.next();
                Assert.assertEquals((String)("failed on " + counter), (Object)order[counter], (Object)sampler.getProperty("TestElement.name"));
                ++counter;
                do {
                    if (controller.hasNext()) continue block0;
lbl21:
                    // 2 sources

                } while (counter < order.length);
            }
        }

        private TestElement makeSampler(String name) {
            TestSampler s = new TestSampler();
            s.setName(name);
            return s;
        }

        public class TestSampler
        extends AbstractSampler {
            public void addCustomTestElement(TestElement t) {
            }

            public SampleResult sample(Entry e) {
                return null;
            }
        }
    }
}

