/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestElement;

public class OnceOnlyController
extends GenericController
implements Serializable {
    public void reInitialize() {
    }

    protected boolean hasNextAtEnd() {
        this.setShortCircuit(true);
        return false;
    }

    public static class Test
    extends TestCase {
        public Test(String name) {
            super(name);
        }

        public void testProcessing() throws Exception {
            GenericController controller = new GenericController();
            OnceOnlyController sub_1 = new OnceOnlyController();
            sub_1.addTestElement(this.makeSampler("one"));
            sub_1.addTestElement(this.makeSampler("two"));
            controller.addTestElement((TestElement)sub_1);
            controller.addTestElement(this.makeSampler("three"));
            LoopController sub_2 = new LoopController();
            sub_2.setLoops(3);
            GenericController sub_3 = new GenericController();
            sub_2.addTestElement(this.makeSampler("four"));
            sub_3.addTestElement(this.makeSampler("five"));
            sub_3.addTestElement(this.makeSampler("six"));
            sub_2.addTestElement((TestElement)sub_3);
            sub_2.addTestElement(this.makeSampler("seven"));
            controller.addTestElement((TestElement)sub_2);
            String[] interleaveOrder = new String[]{"one", "two"};
            String[] order = new String[]{"", "", "three", "four", "five", "six", "seven", "four", "five", "six", "seven", "four", "five", "six", "seven"};
            int counter = 15;
            int i = 0;
            while (i < 4) {
                Assert.assertEquals((int)15, (int)counter);
                counter = 0;
                if (i > 0) {
                    counter = 2;
                }
                while (controller.hasNext()) {
                    Sampler sampler = controller.next();
                    if (i == 0 && counter < 2) {
                        Assert.assertEquals((Object)interleaveOrder[counter], (Object)sampler.getProperty("TestElement.name"));
                    } else {
                        Assert.assertEquals((Object)order[counter], (Object)sampler.getProperty("TestElement.name"));
                    }
                    ++counter;
                }
                ++i;
            }
        }

        private TestElement makeSampler(String name) {
            TestSampler s = new TestSampler();
            s.setName(name);
            return s;
        }

        public class TestSampler
        extends AbstractSampler {
            public void addCustomTestElement(TestElement t) {
            }

            public SampleResult sample(Entry e) {
                return null;
            }
        }
    }
}

