/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.modifiers;

import java.io.Serializable;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.testelement.VariablesCollection;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class CounterConfig
extends ConfigTestElement
implements Serializable,
ThreadListener {
    private static Logger log = LoggingManager.getLoggerFor((String)"jmeter.elements");
    private static final String START = "CounterConfig.start";
    private static final String END = "CounterConfig.end";
    private static final String INCREMENT = "CounterConfig.incr";
    private static final String PER_USER = "CounterConfig.per_user";
    private static final String VAR_NAME = "CounterConfig.name";
    private boolean perUser = false;
    private int globalCounter = -1;
    private int increment = 1;
    private int start = 0;
    private int end = Integer.MAX_VALUE;
    private VariablesCollection vars = new VariablesCollection();
    private int currentIterationCount = -1;

    public synchronized void iterationStarted(int iterationCount) {
        JMeterVariables variables = this.vars.getVariables();
        if (!this.perUser) {
            ++this.globalCounter;
            int value = this.start + this.increment * this.globalCounter;
            if (value > this.end) {
                this.globalCounter = 0;
                value = this.start;
            }
            variables.put(this.getVarName(), Integer.toString(value));
        } else {
            String value = variables.get(this.getVarName());
            if (value == null) {
                variables.put(this.getVarName(), Integer.toString(this.start));
            } else {
                try {
                    int current = Integer.parseInt(value);
                    if ((current += this.increment) > this.end) {
                        current = this.start;
                    }
                    variables.put(this.getVarName(), Integer.toString(current));
                }
                catch (NumberFormatException e) {
                    log.info("Bad number in Counter config", (Throwable)e);
                }
            }
        }
    }

    public void setJMeterVariables(JMeterVariables jmVars) {
        this.vars.addJMeterVariables(jmVars);
        this.start = this.getStart();
        this.end = this.getEnd();
        this.increment = this.getIncrement();
        this.perUser = this.isPerUser();
    }

    public void setStart(int start) {
        this.setProperty(START, new Integer(start));
    }

    public void setStart(String start) {
        this.setProperty(START, start);
    }

    public int getStart() {
        return this.getPropertyAsInt(START);
    }

    public void setEnd(int end) {
        this.setProperty(END, new Integer(end));
    }

    public void setEnd(String end) {
        this.setProperty(END, end);
    }

    public int getEnd() {
        return this.getPropertyAsInt(END);
    }

    public void setIncrement(int inc) {
        this.setProperty(INCREMENT, new Integer(inc));
    }

    public void setIncrement(String incr) {
        this.setProperty(INCREMENT, incr);
    }

    public int getIncrement() {
        return this.getPropertyAsInt(INCREMENT);
    }

    public void setIsPerUser(boolean isPer) {
        this.setProperty(PER_USER, new Boolean(isPer));
    }

    public boolean isPerUser() {
        return this.getPropertyAsBoolean(PER_USER);
    }

    public void setVarName(String name) {
        this.setProperty(VAR_NAME, name);
    }

    public String getVarName() {
        return this.getPropertyAsString(VAR_NAME);
    }

    static {
        START = START;
        END = END;
        INCREMENT = INCREMENT;
        PER_USER = PER_USER;
        VAR_NAME = VAR_NAME;
    }
}

