/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.modifiers.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.modifiers.UserParameters;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class UserParametersGui
extends AbstractConfigGui {
    private String THREAD_COLUMNS = JMeterUtils.getResString((String)"user");
    JTable paramTable;
    PowerTableModel tableModel;
    private int numUserColumns = 1;
    private JButton addParameterButton;
    private JButton addUserButton;
    private JButton deleteRowButton;
    private JButton deleteColumnButton;
    static /* synthetic */ Class class$java$lang$String;

    public UserParametersGui() {
        this.init();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"user_parameters_title");
    }

    public void configure(TestElement el) {
        this.tableModel.clearData();
        UserParameters params = (UserParameters)el;
        List names = params.getNames();
        List threadValues = params.getThreadLists();
        this.tableModel.setColumnData(0, names);
        Iterator iter = threadValues.iterator();
        if (iter.hasNext()) {
            this.tableModel.setColumnData(1, (List)iter.next());
        }
        int count = 2;
        while (iter.hasNext()) {
            String colName = this.THREAD_COLUMNS + "_" + count;
            this.tableModel.addNewColumn(colName, class$java$lang$String == null ? UserParametersGui.class$("java.lang.String") : class$java$lang$String);
            this.tableModel.setColumnData(count, (List)iter.next());
            ++count;
        }
        super.configure(el);
    }

    public TestElement createTestElement() {
        UserParameters params = new UserParameters();
        params.setNames(this.tableModel.getColumnData(JMeterUtils.getResString((String)"name")));
        LinkedList<List> threadLists = new LinkedList<List>();
        int x = 1;
        while (x < this.tableModel.getColumnCount()) {
            threadLists.add(this.tableModel.getColumnData(this.THREAD_COLUMNS + "_" + x));
            ++x;
        }
        params.setThreadLists(threadLists);
        super.configureTestElement((TestElement)params);
        return params;
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add(this.makeTitlePanel(), "North");
        this.add(this.makeParameterPanel(), "Center");
    }

    private JPanel makeTitlePanel() {
        JLabel title = new JLabel(JMeterUtils.getResString((String)"user_parameters_title"));
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.add((Component)title, "North");
        titlePanel.add((Component)this.getNamePanel(), "South");
        return titlePanel;
    }

    private JPanel makeParameterPanel() {
        JPanel paramPanel = new JPanel(new BorderLayout());
        JLabel tableLabel = new JLabel(JMeterUtils.getResString((String)"user_parameters_table"));
        this.tableModel = new PowerTableModel(new String[]{JMeterUtils.getResString((String)"name"), this.THREAD_COLUMNS + "_" + this.numUserColumns}, new Class[]{class$java$lang$String == null ? (class$java$lang$String = UserParametersGui.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = UserParametersGui.class$("java.lang.String")) : class$java$lang$String});
        this.paramTable = new JTable((TableModel)this.tableModel);
        this.paramTable.setRowSelectionAllowed(true);
        this.paramTable.setColumnSelectionAllowed(true);
        this.paramTable.setSelectionMode(0);
        this.paramTable.setCellSelectionEnabled(true);
        paramPanel.add((Component)tableLabel, "North");
        JScrollPane scroller = new JScrollPane(this.paramTable);
        Dimension tableDim = scroller.getPreferredSize();
        tableDim.height = 70;
        scroller.setPreferredSize(tableDim);
        scroller.setColumnHeaderView(this.paramTable.getTableHeader());
        paramPanel.add((Component)scroller, "Center");
        paramPanel.add((Component)this.makeButtonPanel(), "South");
        return paramPanel;
    }

    private JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        this.addParameterButton = new JButton(JMeterUtils.getResString((String)"add_parameter"));
        this.addUserButton = new JButton(JMeterUtils.getResString((String)"add_user"));
        this.deleteRowButton = new JButton(JMeterUtils.getResString((String)"delete_parameter"));
        this.deleteColumnButton = new JButton(JMeterUtils.getResString((String)"delete_user"));
        buttonPanel.add(this.addParameterButton);
        buttonPanel.add(this.addUserButton);
        buttonPanel.add(this.deleteRowButton);
        buttonPanel.add(this.deleteColumnButton);
        this.addParameterButton.addActionListener(new AddParamAction());
        this.addUserButton.addActionListener(new AddUserAction());
        this.deleteRowButton.addActionListener(new DeleteRowAction());
        this.deleteColumnButton.addActionListener(new DeleteColumnAction());
        return buttonPanel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DeleteColumnAction
    implements ActionListener {
        private DeleteColumnAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int colSelected;
            if (UserParametersGui.this.paramTable.isEditing()) {
                TableCellEditor cellEditor = UserParametersGui.this.paramTable.getCellEditor(UserParametersGui.this.paramTable.getEditingRow(), UserParametersGui.this.paramTable.getEditingColumn());
                cellEditor.cancelCellEditing();
            }
            if ((colSelected = UserParametersGui.this.paramTable.getSelectedColumn()) == 0 || colSelected == 1) {
                JOptionPane.showMessageDialog(null, JMeterUtils.getResString((String)"column_delete_disallowed"), "Error", 0);
                return;
            }
            if (colSelected >= 0) {
                UserParametersGui.this.tableModel.removeColumn(colSelected);
                UserParametersGui.this.tableModel.fireTableDataChanged();
                if (UserParametersGui.this.tableModel.getColumnCount() == 0) {
                    UserParametersGui.this.deleteColumnButton.setEnabled(false);
                } else {
                    if (colSelected >= UserParametersGui.this.tableModel.getColumnCount()) {
                        --colSelected;
                    }
                    UserParametersGui.this.paramTable.setColumnSelectionInterval(colSelected, colSelected);
                }
            }
        }
    }

    private class DeleteRowAction
    implements ActionListener {
        private DeleteRowAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int rowSelected;
            if (UserParametersGui.this.paramTable.isEditing()) {
                TableCellEditor cellEditor = UserParametersGui.this.paramTable.getCellEditor(UserParametersGui.this.paramTable.getEditingRow(), UserParametersGui.this.paramTable.getEditingColumn());
                cellEditor.cancelCellEditing();
            }
            if ((rowSelected = UserParametersGui.this.paramTable.getSelectedRow()) >= 0) {
                UserParametersGui.this.tableModel.removeRow(rowSelected);
                UserParametersGui.this.tableModel.fireTableDataChanged();
                if (UserParametersGui.this.tableModel.getRowCount() == 0) {
                    UserParametersGui.this.deleteRowButton.setEnabled(false);
                } else {
                    int rowToSelect = rowSelected;
                    if (rowSelected >= UserParametersGui.this.tableModel.getRowCount()) {
                        rowToSelect = rowSelected - 1;
                    }
                    UserParametersGui.this.paramTable.setRowSelectionInterval(rowToSelect, rowToSelect);
                }
            }
        }
    }

    private class AddUserAction
    implements ActionListener {
        private AddUserAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (UserParametersGui.this.paramTable.isEditing()) {
                TableCellEditor cellEditor = UserParametersGui.this.paramTable.getCellEditor(UserParametersGui.this.paramTable.getEditingRow(), UserParametersGui.this.paramTable.getEditingColumn());
                cellEditor.stopCellEditing();
            }
            UserParametersGui.this.tableModel.addNewColumn(UserParametersGui.this.THREAD_COLUMNS + "_" + UserParametersGui.this.tableModel.getColumnCount(), class$java$lang$String == null ? (class$java$lang$String = UserParametersGui.class$("java.lang.String")) : class$java$lang$String);
            UserParametersGui.this.tableModel.fireTableDataChanged();
            UserParametersGui.this.deleteColumnButton.setEnabled(true);
            int colToSelect = UserParametersGui.this.tableModel.getColumnCount() - 1;
            UserParametersGui.this.paramTable.setColumnSelectionInterval(colToSelect, colToSelect);
        }
    }

    private class AddParamAction
    implements ActionListener {
        private AddParamAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (UserParametersGui.this.paramTable.isEditing()) {
                TableCellEditor cellEditor = UserParametersGui.this.paramTable.getCellEditor(UserParametersGui.this.paramTable.getEditingRow(), UserParametersGui.this.paramTable.getEditingColumn());
                cellEditor.stopCellEditing();
            }
            UserParametersGui.this.tableModel.addNewRow();
            UserParametersGui.this.tableModel.fireTableDataChanged();
            UserParametersGui.this.deleteRowButton.setEnabled(true);
            int rowToSelect = UserParametersGui.this.tableModel.getRowCount() - 1;
            UserParametersGui.this.paramTable.setRowSelectionInterval(rowToSelect, rowToSelect);
        }
    }
}

