/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.reporters;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class MailerResultCollector
extends ResultCollector
implements Serializable {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.elements");
    String address;
    String from = JMeterUtils.getPropDefault((String)"mailer.from", (String)"");
    String smtpHost;
    String failSubject;
    String successSubject;
    long failureCount = 0L;
    long successCount = 0L;
    long failureLimit = 2L;
    long successLimit = 2L;
    boolean failureMsgSent = false;
    boolean siteDown = false;
    boolean successMsgSent = false;
    static /* synthetic */ Class class$org$apache$jmeter$visualizers$MailerVisualizer;

    public MailerResultCollector() {
        this.address = JMeterUtils.getPropDefault((String)"mailer.addressies", (String)"");
        this.smtpHost = JMeterUtils.getPropDefault((String)"mailer.smtphost", (String)"");
        this.failSubject = JMeterUtils.getPropDefault((String)"mailer.failsubject", (String)"");
        this.successSubject = JMeterUtils.getPropDefault((String)"mailer.successsubject", (String)"");
        try {
            this.failureLimit = Long.parseLong(JMeterUtils.getPropDefault((String)"mailer.failurelimit", (String)"2"));
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            this.successLimit = Long.parseLong(JMeterUtils.getPropDefault((String)"mailer.successlimit", (String)"2"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public Class getGuiClass() {
        return class$org$apache$jmeter$visualizers$MailerVisualizer == null ? (class$org$apache$jmeter$visualizers$MailerVisualizer = MailerResultCollector.class$("org.apache.jmeter.visualizers.MailerVisualizer")) : class$org$apache$jmeter$visualizers$MailerVisualizer;
    }

    public String getClassLabel() {
        return JMeterUtils.getResString((String)"email_results_title");
    }

    public long getFailureLimit() {
        return this.failureLimit;
    }

    public long getFailureCount() {
        return this.failureCount;
    }

    public long getSuccessLimit() {
        return this.successLimit;
    }

    public void setFailureLimit(long limit) {
        this.failureLimit = limit;
    }

    public void setSuccessLimit(long limit) {
        this.successLimit = limit;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getFrom() {
        return this.from;
    }

    public void setSmtpHost(String host) {
        this.smtpHost = host;
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    public void setFailSubject(String subject) {
        this.failSubject = subject;
    }

    public String getFailSubject() {
        return this.failSubject;
    }

    public void setSuccessSubject(String subject) {
        this.successSubject = subject;
    }

    public String getSuccessSubject() {
        return this.successSubject;
    }

    public synchronized boolean isFailing() {
        return this.failureCount > this.failureLimit;
    }

    public void sendTestMessage() {
        log.debug("### Test To:  " + this.address + ", " + "Via:  " + this.smtpHost + ", " + "Fail Subject:  " + this.failSubject + ", " + "Success Subject:  " + this.successSubject);
        String testMessage = "### Test To:  " + this.address + ", " + "Via:  " + this.smtpHost + ", " + "Fail Subject:  " + this.failSubject + ", " + "Success Subject:  " + this.successSubject;
        Vector addressVector = this.newAddressVector(this.address);
        MailerResultCollector.sendMail(this.from, addressVector, "Testing addressies", testMessage, this.smtpHost);
    }

    public synchronized void sampleOccurred(SampleEvent event) {
        Vector addressVector;
        super.sampleOccurred(event);
        SampleResult sample = event.getResult();
        if (!sample.isSuccessful()) {
            ++this.failureCount;
        } else {
            ++this.successCount;
        }
        if (this.isFailing() && !this.siteDown && !this.failureMsgSent) {
            addressVector = this.newAddressVector(this.address);
            MailerResultCollector.sendMail(this.from, addressVector, this.failSubject, "URL Failed: " + sample.getSampleLabel(), this.smtpHost);
            this.siteDown = true;
            this.failureMsgSent = true;
            this.successCount = 0L;
        }
        if (this.siteDown && sample.getTime() != -1L & !this.successMsgSent && this.successCount > this.successLimit) {
            addressVector = this.newAddressVector(this.address);
            MailerResultCollector.sendMail(this.from, addressVector, this.successSubject, "URL Restarted: " + sample.getSampleLabel(), this.smtpHost);
            this.siteDown = false;
            this.successMsgSent = true;
        }
        if (this.successMsgSent && this.failureMsgSent) {
            this.clear();
        }
    }

    public static synchronized void sendMail(String from, Vector vEmails, String subject, String attText, String SMTPHost) {
        try {
            String host = SMTPHost;
            boolean debug = Boolean.valueOf(host);
            InetAddress remote = InetAddress.getByName(host);
            InternetAddress[] address = new InternetAddress[vEmails.size()];
            int k = 0;
            while (k < vEmails.size()) {
                address[k] = new InternetAddress(vEmails.elementAt(k).toString());
                ++k;
            }
            Properties props = new Properties();
            props.put("mail.smtp.host", host);
            Session session = Session.getDefaultInstance((Properties)props, null);
            session.setDebug(debug);
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(from));
            msg.setRecipients(Message.RecipientType.TO, (Address[])address);
            msg.setSubject(subject);
            msg.setText(attText);
            Transport.send((Message)msg);
            log.info("Mail sent successfully!!");
        }
        catch (UnknownHostException e1) {
            log.fatalError("NxError:Invalid Mail Server ", (Throwable)e1);
            System.exit(1);
        }
        catch (Exception e) {
            log.fatalError("", (Throwable)e);
            System.exit(1);
        }
    }

    public synchronized Vector newAddressVector(String theAddressie) {
        Vector<String> addressVector = new Vector<String>();
        String addressSep = ", ";
        StringTokenizer next = new StringTokenizer(theAddressie, addressSep);
        while (next.hasMoreTokens()) {
            String theToken = next.nextToken();
            if (theToken.indexOf("@") <= 0) continue;
            addressVector.addElement(theToken);
        }
        return addressVector;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

