/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.timers;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.testelement.VariablesCollection;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.timers.Timer;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ConstantTimer
extends AbstractTestElement
implements Timer,
Serializable,
ThreadListener {
    private static Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.elements");
    public static final String DELAY = "ConstantTimer.delay";
    private VariablesCollection vars = new VariablesCollection();
    private JMeterVariables variables;
    private static List addableList;
    private long delay = 0L;

    public void setDelay(String delay) {
        this.setProperty(DELAY, delay);
    }

    public void setRange(double range) {
    }

    public String getDelay() {
        return (String)this.getProperty(DELAY);
    }

    public double getRange() {
        return 0.0;
    }

    public long delay() {
        return this.delay;
    }

    public String toString() {
        return JMeterUtils.getResString((String)"constant_timer_memo");
    }

    public void iterationStarted(int iterationCount) {
        this.variables = this.vars.getVariables();
        try {
            String delayString = (String)this.getProperty(DELAY);
            this.delay = Long.parseLong(delayString);
        }
        catch (ClassCastException ex) {
            log.error("Unable to determine delay - you may have used an undefined variable in the test element with the name: " + this.getName(), (Throwable)ex);
            this.delay = 0L;
        }
    }

    public void setJMeterVariables(JMeterVariables jmVars) {
    }

    static {
        DELAY = DELAY;
        addableList = new LinkedList();
    }
}

