/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.timers.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.timers.ConstantThroughputTimer;
import org.apache.jmeter.timers.gui.AbstractTimerGui;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class ConstantThroughputTimerGui
extends AbstractTimerGui
implements KeyListener {
    private final String DEFAULT_THROUGHPUT = "60";
    private final String THROUGHPUT_FIELD = "Throughput Field";
    private JTextField throughputField;

    public ConstantThroughputTimerGui() {
        this.init();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"constant_throughput_timer_title");
    }

    public TestElement createTestElement() {
        ConstantThroughputTimer timer = new ConstantThroughputTimer();
        this.configureTestElement((TestElement)timer);
        timer.setThroughput(Long.parseLong(this.throughputField.getText()));
        return timer;
    }

    public void configure(TestElement el) {
        super.configure(el);
        ConstantThroughputTimer e = (ConstantThroughputTimer)el;
        this.throughputField.setText(String.valueOf(e.getThroughput()));
    }

    public void keyReleased(KeyEvent e) {
        block3: {
            String n = e.getComponent().getName();
            if (n.equals("Throughput Field")) {
                try {
                    Long.parseLong(this.throughputField.getText());
                }
                catch (NumberFormatException nfe) {
                    if (this.throughputField.getText().length() <= 0) break block3;
                    JOptionPane.showMessageDialog((Component)((Object)this), "You must enter a valid number", "Invalid data", 2);
                }
            }
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 2, 1));
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
        JLabel panelTitleLabel = new JLabel(JMeterUtils.getResString((String)"constant_throughput_timer_title"));
        Font curFont = panelTitleLabel.getFont();
        int curFontSize = curFont.getSize();
        panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
        mainPanel.add(panelTitleLabel);
        mainPanel.add((Component)this.getNamePanel());
        JPanel throughputPanel = new JPanel();
        JLabel throughputLabel = new JLabel(JMeterUtils.getResString((String)"constant_throughput_timer_throughput"));
        throughputPanel.add(throughputLabel);
        this.throughputField = new JTextField(6);
        this.throughputField.setText("60");
        throughputPanel.add(this.throughputField);
        mainPanel.add(throughputPanel);
        this.throughputField.addKeyListener(this);
        this.throughputField.setName("Throughput Field");
        this.add(mainPanel);
    }
}

