/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.timers.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.gui.util.FocusRequester;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.timers.GaussianRandomTimer;
import org.apache.jmeter.timers.gui.AbstractTimerGui;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class GaussianRandomTimerGui
extends AbstractTimerGui
implements KeyListener {
    private final String DELAY_FIELD = "Delay Field";
    private final String RANGE_FIELD = "Range Field";
    public final String DEFAULT_DELAY = "300";
    public final String DEFAULT_RANGE = "100.0";
    private JTextField delayField;
    private JTextField rangeField;

    public GaussianRandomTimerGui() {
        this.init();
    }

    public static void error(Exception e, JComponent thrower) {
        JOptionPane.showMessageDialog(thrower, e, "Error", 0);
    }

    public TestElement createTestElement() {
        GaussianRandomTimer timer = new GaussianRandomTimer();
        this.configureTestElement((TestElement)timer);
        timer.setDelay(this.delayField.getText());
        timer.setRange(Double.parseDouble(this.rangeField.getText()));
        return timer;
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.delayField.setText(el.getProperty("ConstantTimer.delay").toString());
        this.rangeField.setText(el.getProperty("RandomTimer.range").toString());
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"gaussian_timer_title");
    }

    public void keyReleased(KeyEvent e) {
        block3: {
            String temp = e.getComponent().getName();
            if (temp.equals("Range Field")) {
                try {
                    Double.parseDouble(this.rangeField.getText());
                }
                catch (NumberFormatException nfe) {
                    if (this.rangeField.getText().length() <= 0) break block3;
                    JOptionPane.showMessageDialog((Component)((Object)this), "You must enter a valid number", "Invalid data", 2);
                }
            }
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 2, 1));
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
        JLabel panelTitleLabel = new JLabel(JMeterUtils.getResString((String)"gaussian_timer_title"));
        Font curFont = panelTitleLabel.getFont();
        int curFontSize = curFont.getSize();
        panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
        mainPanel.add(panelTitleLabel);
        mainPanel.add((Component)this.getNamePanel());
        JPanel threadDelayPropsPanel = new JPanel();
        margin = new EmptyBorder(5, 10, 10, 10);
        threadDelayPropsPanel.setLayout((LayoutManager)new VerticalLayout(0, 2));
        threadDelayPropsPanel.setBorder(new CompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"thread_delay_properties")), margin));
        JPanel delayDevPanel = new JPanel();
        JLabel rangeLabel = new JLabel(JMeterUtils.getResString((String)"gaussian_timer_range"));
        delayDevPanel.add(rangeLabel);
        this.rangeField = new JTextField(6);
        this.rangeField.setText("100.0");
        this.rangeField.setName("Range Field");
        this.rangeField.addKeyListener(this);
        delayDevPanel.add(this.rangeField);
        threadDelayPropsPanel.add(delayDevPanel);
        mainPanel.add(threadDelayPropsPanel);
        JPanel avgDelayPanel = new JPanel();
        JLabel delayLabel = new JLabel(JMeterUtils.getResString((String)"gaussian_timer_delay"));
        avgDelayPanel.add(delayLabel);
        this.delayField = new JTextField(20);
        this.delayField.setText("300");
        this.delayField.setName("Delay Field");
        this.delayField.addKeyListener(this);
        avgDelayPanel.add(this.delayField);
        threadDelayPropsPanel.add(avgDelayPanel);
        this.add(mainPanel);
        new FocusRequester((Component)this.rangeField);
    }
}

