/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class AssertionVisualizer
extends AbstractVisualizer
implements Clearable {
    private JTextArea textArea;

    public AssertionVisualizer() {
        this.init();
        this.setName(this.getStaticLabel());
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"assertion_visualizer_title");
    }

    public void add(SampleResult sample) {
        this.textArea.append(sample.getSamplerData().toString());
        this.textArea.append(this.getAssertionResult(sample));
        this.textArea.append("\n");
    }

    public void clear() {
        this.textArea.setText("");
    }

    private String getAssertionResult(SampleResult res) {
        if (res != null) {
            StringBuffer display = new StringBuffer();
            List<AssertionResult> assertionResults = Arrays.asList(res.getAssertionResults());
            if (assertionResults != null) {
                Iterator<AssertionResult> iter = assertionResults.iterator();
                while (iter.hasNext()) {
                    AssertionResult item = iter.next();
                    if (!item.isFailure() && !item.isError()) continue;
                    display.append("\n\t\t");
                    display.append(item.getFailureMessage());
                }
            }
            return display.toString();
        }
        return "";
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
        JLabel panelTitleLabel = new JLabel(JMeterUtils.getResString((String)"assertion_visualizer_title"));
        Font curFont = panelTitleLabel.getFont();
        int curFontSize = curFont.getSize();
        panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
        mainPanel.add(panelTitleLabel);
        mainPanel.add((Component)this.getNamePanel());
        mainPanel.add((Component)this.getFilePanel());
        JLabel textAreaLabel = new JLabel(JMeterUtils.getResString((String)"assertion_textarea_label"));
        mainPanel.add(textAreaLabel);
        this.textArea = new JTextArea(10, 40);
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(false);
        JScrollPane areaScrollPane = new JScrollPane(this.textArea);
        areaScrollPane.setVerticalScrollBarPolicy(22);
        areaScrollPane.setHorizontalScrollBarPolicy(30);
        this.add(mainPanel, "North");
        this.add(areaScrollPane, "Center");
    }
}

