/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.visualizers.ImageVisualizer;

public class BarVisualizer
extends JPanel
implements ImageVisualizer,
ChangeListener {
    private static final int MAX_SCALE = 2000;
    private Graph graph = new Graph();
    private JSlider slider = new JSlider(1, 0, 2000, 1000);

    public BarVisualizer() {
        this.slider.addChangeListener(this);
        this.slider.setPaintLabels(false);
        this.slider.setPaintTicks(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.slider, "West");
        this.add((Component)this.graph, "Center");
        this.setPreferredSize(new Dimension(500, 100));
    }

    public void stateChanged(ChangeEvent e) {
        int limit = this.slider.getValue();
        this.graph.setLimit(limit);
        this.repaint();
    }

    public synchronized void add(SampleResult sampleResult) {
        long s = sampleResult.getTime();
        this.graph.add((int)s);
        this.repaint();
    }

    public synchronized void clear() {
        this.graph.clear();
        this.repaint();
    }

    public String toString() {
        return "Show the samples as scrolling bars";
    }

    public JPanel getControlPanel() {
        return this;
    }

    public Image getImage() {
        Image result = this.graph.createImage(this.graph.getWidth(), this.graph.getHeight());
        this.graph.paintComponent(result.getGraphics());
        return result;
    }

    static {
        MAX_SCALE = 2000;
    }

    class Graph
    extends JComponent {
        private final int GRIDS = 10;
        private int limit = 1000;
        private int scale;
        private int counter = 0;
        private Vector samples = new Vector();
        private Color barColor = Color.lightGray;

        public Graph() {
            this.scale = this.limit / 10;
        }

        public synchronized void setLimit(int limit) {
            this.limit = limit;
            this.scale = limit / 10;
        }

        public void add(int sample) {
            this.samples.addElement(new Integer(sample));
            ++this.counter;
        }

        public void clear() {
            this.samples.removeAllElements();
            this.counter = 0;
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension d = this.getSize();
            int i = 1;
            while (i < 10) {
                int y = d.height - i * d.height / 10;
                g.setColor(Color.black);
                g.drawLine(5, y, d.width - 35, y);
                g.setColor(Color.blue);
                g.drawString(Integer.toString(i * this.scale), d.width - 30, y + this.getFont().getSize() / 2);
                ++i;
            }
            int bars = (d.width - 40) / 8;
            if (this.counter < bars) {
                bars = this.counter;
            }
            if (this.limit == 0) {
                this.limit = 1;
            }
            int i2 = bars;
            while (i2 > 0) {
                int sample = (Integer)this.samples.elementAt(this.counter - i2) * d.height / this.limit;
                g.setColor(this.barColor);
                g.fill3DRect(d.width - 36 - 8 * i2, d.height - sample, 5, sample, true);
                --i2;
            }
        }
    }
}

