/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.apache.jmeter.gui.util.JMeterColor;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.visualizers.GraphListener;
import org.apache.jmeter.visualizers.GraphModel;
import org.apache.jmeter.visualizers.Sample;

public class Graph
extends JComponent
implements Scrollable,
GraphListener,
Clearable {
    private boolean data = true;
    private boolean average = true;
    private boolean deviation = true;
    private boolean throughput = true;
    private GraphModel model;
    private static int width = 2000;

    public Graph() {
        this.setPreferredSize(new Dimension(width, 800));
    }

    public Graph(GraphModel model) {
        this();
        this.setModel(model);
    }

    private void setModel(Object model) {
        this.model = (GraphModel)model;
        this.model.addGraphListener(this);
        this.repaint();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 5;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return (int)((double)visibleRect.width * 0.9);
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    public void clear() {
    }

    public void enableData(boolean value) {
        this.data = value;
    }

    public void enableAverage(boolean value) {
        this.average = value;
    }

    public void enableDeviation(boolean value) {
        this.deviation = value;
    }

    public void enableThroughput(boolean value) {
        this.throughput = value;
    }

    public void updateGui() {
        this.repaint();
    }

    public void updateGui(final Sample oneSample) {
        final int xPos = this.model.getSampleCount();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Graphics g = Graph.this.getGraphics();
                if (g != null) {
                    Graph.this.drawSample(xPos, oneSample, g);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension d = this.getSize();
        List list = this.model.getSamples();
        synchronized (list) {
            Iterator e = this.model.getSamples().iterator();
            int i = 0;
            while (e.hasNext()) {
                Sample s = (Sample)e.next();
                this.drawSample(i, s, g);
                ++i;
            }
        }
    }

    private void drawSample(int x, Sample oneSample, Graphics g) {
        Dimension d = this.getSize();
        if (this.data) {
            int data = (int)(oneSample.data * (long)d.height / this.model.getGraphMax());
            if (!oneSample.error) {
                g.setColor(Color.black);
            } else {
                g.setColor(JMeterColor.YELLOW);
            }
            g.drawLine(x % width, d.height - data, x % width, d.height - data - 1);
        }
        if (this.average) {
            int average = (int)(oneSample.average * (long)d.height / this.model.getGraphMax());
            g.setColor(Color.blue);
            g.drawLine(x % width, d.height - average, x % width, d.height - average - 1);
        }
        if (this.deviation) {
            int deviation = (int)(oneSample.deviation * (long)d.height / this.model.getGraphMax());
            g.setColor(Color.red);
            g.drawLine(x % width, d.height - deviation, x % width, d.height - deviation - 1);
        }
        if (this.throughput) {
            int throughput = (int)(oneSample.throughput * (float)d.height / (float)this.model.getThroughputMax());
            g.setColor(JMeterColor.dark_green);
            g.drawLine(x % width, d.height - throughput, x % width, d.height - throughput - 1);
        }
    }
}

