/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.visualizers.GraphAccumListener;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class GraphAccumModel
implements Clearable,
Serializable {
    protected String name;
    protected List samples;
    protected List listeners;
    protected long averageSum = 0L;
    protected long variationSum = 0L;
    protected long counter = 0L;
    protected long previous = 0L;
    protected long max = 1L;
    protected boolean bigChange = false;
    protected SampleResult current;
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.gui");

    public GraphAccumModel() {
        log.debug("Start : GraphAccumModel1");
        this.listeners = new LinkedList();
        this.samples = Collections.synchronizedList(new LinkedList());
        log.debug("End : GraphAccumModel1");
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSampleCount() {
        return this.samples.size();
    }

    public List getList() {
        return this.samples;
    }

    public String getName() {
        return this.name;
    }

    public long getMax() {
        log.debug("getMax1 : Returning - " + this.max);
        return this.max;
    }

    public void addGraphAccumListener(GraphAccumListener listener) {
        this.listeners.add(listener);
    }

    public void clear() {
        log.debug("Start : clear1");
        this.samples.clear();
        this.max = 1L;
        this.bigChange = true;
        this.fireDataChanged();
        log.debug("End : clear1");
    }

    public void addNewSample(SampleResult res) {
        log.debug("Start : addNewSample1");
        long totalTime = res.getTime();
        if (log.isDebugEnabled()) {
            log.debug("addNewSample1 : time - " + totalTime);
            log.debug("addNewSample1 : max - " + this.max);
        }
        if (totalTime > this.max) {
            this.bigChange = true;
            this.max = totalTime;
        }
        this.current = res;
        this.samples.add(res);
        log.debug("End : addNewSample1");
        this.fireDataChanged();
    }

    protected void fireDataChanged() {
        log.debug("Start : fireDataChanged1");
        Iterator iter = this.listeners.iterator();
        if (this.bigChange) {
            while (iter.hasNext()) {
                ((GraphAccumListener)iter.next()).updateGui();
            }
            this.bigChange = false;
        } else {
            this.quickUpdate(this.current);
        }
        log.debug("End : fireDataChanged1");
    }

    protected void quickUpdate(SampleResult s) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((GraphAccumListener)iter.next()).updateGui(s);
        }
    }
}

