/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.visualizers.GraphListener;
import org.apache.jmeter.visualizers.Sample;

public class GraphModel
implements Clearable,
Serializable {
    private String name;
    private List samples;
    private List listeners;
    private long averageSum = 0L;
    private long variationSum = 0L;
    private long counter = 0L;
    private long previous = 0L;
    private long max = 1L;
    private boolean bigChange = false;
    private Sample current = new Sample(0L, 0L, 0L, 0.0f, false);
    private long startTime = 0L;
    private int throughputMax = 20;
    private long graphMax = 20L;
    static /* synthetic */ Class class$org$apache$jmeter$visualizers$GraphVisualizer;

    public GraphModel() {
        this.listeners = new LinkedList();
        this.samples = Collections.synchronizedList(new LinkedList());
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getCurrentData() {
        return this.current.data;
    }

    public long getCurrentAverage() {
        return this.current.average;
    }

    public long getCurrentDeviation() {
        return this.current.deviation;
    }

    public float getCurrentThroughput() {
        return this.current.throughput;
    }

    public int getSampleCount() {
        return this.samples.size();
    }

    public List getSamples() {
        return this.samples;
    }

    public Class getGuiClass() {
        return class$org$apache$jmeter$visualizers$GraphVisualizer == null ? (class$org$apache$jmeter$visualizers$GraphVisualizer = GraphModel.class$("org.apache.jmeter.visualizers.GraphVisualizer")) : class$org$apache$jmeter$visualizers$GraphVisualizer;
    }

    public String getName() {
        return this.name;
    }

    public long getMaxSample() {
        return this.max;
    }

    public long getGraphMax() {
        return this.graphMax;
    }

    public int getThroughputMax() {
        return this.throughputMax;
    }

    public void addGraphListener(GraphListener listener) {
        this.listeners.add(listener);
    }

    public Sample addSample(SampleResult e) {
        Sample s = this.addNewSample(e.getTime(), e.getTimeStamp(), e.isSuccessful());
        this.fireDataChanged();
        return s;
    }

    public void clear() {
        this.samples.clear();
        this.averageSum = 0L;
        this.variationSum = 0L;
        this.counter = 0L;
        this.previous = 0L;
        this.max = 1L;
        this.graphMax = 1L;
        this.bigChange = true;
        this.current = new Sample(0L, 0L, 0L, 0.0f, false);
        this.fireDataChanged();
    }

    protected void fireDataChanged() {
        Iterator iter = this.listeners.iterator();
        if (this.bigChange) {
            while (iter.hasNext()) {
                ((GraphListener)iter.next()).updateGui();
            }
            this.bigChange = false;
        } else {
            this.quickUpdate(this.current);
        }
    }

    protected void quickUpdate(Sample s) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((GraphListener)iter.next()).updateGui(s);
        }
    }

    protected Sample addNewSample(long sample, long timeStamp, boolean success) {
        if (this.samples.size() == 0) {
            this.startTime = timeStamp;
        }
        if (sample > this.max) {
            this.max = sample;
        }
        this.averageSum += sample;
        long average = this.averageSum / ++this.counter;
        this.variationSum = (long)((double)this.variationSum + Math.pow(sample - average, 2.0));
        long deviation = (long)Math.pow(this.variationSum / this.counter, 0.5);
        float throughput = 0.0f;
        if (timeStamp - this.startTime > 0L) {
            throughput = (float)(this.samples.size() + 1) / (float)(timeStamp - this.startTime) * 60000.0f;
        }
        if (throughput > (float)this.throughputMax) {
            this.bigChange = true;
            this.throughputMax = (int)(throughput * 1.5f);
        }
        if (average > this.graphMax) {
            this.bigChange = true;
            this.graphMax = average * 3L;
        }
        if (deviation > this.graphMax) {
            this.bigChange = true;
            this.graphMax = deviation * 3L;
        }
        Sample s = new Sample(sample, average, deviation, throughput, !success);
        this.previous = sample;
        this.current = s;
        this.samples.add(s);
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

