/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.gui.util.JMeterColor;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Graph;
import org.apache.jmeter.visualizers.GraphListener;
import org.apache.jmeter.visualizers.GraphModel;
import org.apache.jmeter.visualizers.ImageVisualizer;
import org.apache.jmeter.visualizers.Sample;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class GraphVisualizer
extends AbstractVisualizer
implements ImageVisualizer,
ItemListener,
GraphListener,
Clearable {
    GraphModel model;
    private JTextField maxYField = null;
    private JTextField minYField = null;
    private JTextField noSamplesField = null;
    String minute = JMeterUtils.getResString((String)"minute");
    private Graph graph;
    private JCheckBox data;
    private JCheckBox average;
    private JCheckBox deviation;
    private JCheckBox throughput;
    private JTextField dataField;
    private JTextField averageField;
    private JTextField deviationField;
    private JTextField throughputField;
    private boolean perSecond = false;

    public GraphVisualizer() {
        this.model = new GraphModel();
        this.model.addGraphListener(this);
        this.graph = new Graph(this.model);
        this.init();
    }

    public Image getImage() {
        Image result = this.graph.createImage(this.graph.getWidth(), this.graph.getHeight());
        this.graph.paintComponent(result.getGraphics());
        return result;
    }

    public void updateGui() {
        this.graph.updateGui();
        this.noSamplesField.setText(Long.toString(this.model.getSampleCount()));
        this.dataField.setText(Long.toString(this.model.getCurrentData()));
        this.averageField.setText(Long.toString(this.model.getCurrentAverage()));
        this.deviationField.setText(Long.toString(this.model.getCurrentDeviation()));
        this.throughputField.setText(Float.toString(this.model.getCurrentThroughput()) + "/" + this.minute);
        this.updateYAxis();
    }

    public void updateGui(Sample s) {
        this.graph.updateGui(s);
        this.noSamplesField.setText(Long.toString(this.model.getSampleCount()));
        this.dataField.setText(Long.toString(s.data));
        this.averageField.setText(Long.toString(s.average));
        this.deviationField.setText(Long.toString(s.deviation));
        this.throughputField.setText(Float.toString(s.throughput) + "/" + this.minute);
        this.updateYAxis();
    }

    public void add(SampleResult res) {
        this.model.addSample(res);
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"graph_results_title");
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getItem() == this.data) {
            this.graph.enableData(e.getStateChange() == 1);
        } else if (e.getItem() == this.average) {
            this.graph.enableAverage(e.getStateChange() == 1);
        } else if (e.getItem() == this.deviation) {
            this.graph.enableDeviation(e.getStateChange() == 1);
        } else if (e.getItem() == this.throughput) {
            this.graph.enableThroughput(e.getStateChange() == 1);
        }
        this.graph.repaint();
    }

    public synchronized void clear() {
        this.model.clear();
        this.dataField.setText("0000");
        this.averageField.setText("0000");
        this.deviationField.setText("0000");
        this.throughputField.setText("0/" + this.minute);
        this.updateYAxis();
        this.repaint();
    }

    public String toString() {
        return "Show the samples analysis as dot plots";
    }

    private void updateYAxis() {
        this.maxYField.setText(Long.toString(this.model.getGraphMax()));
        this.minYField.setText("0");
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
        JLabel panelTitleLabel = new JLabel(JMeterUtils.getResString((String)"graph_results_title"));
        Font curFont = panelTitleLabel.getFont();
        int curFontSize = curFont.getSize();
        panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
        mainPanel.add(panelTitleLabel);
        mainPanel.add((Component)this.getNamePanel());
        mainPanel.add((Component)this.getFilePanel());
        JPanel chooseGraphsPanel = new JPanel();
        chooseGraphsPanel.setLayout(new FlowLayout());
        JLabel selectGraphsLabel = new JLabel(JMeterUtils.getResString((String)"graph_choose_graphs"));
        this.data = new JCheckBox(JMeterUtils.getResString((String)"graph_results_data"));
        this.data.setSelected(true);
        this.data.addItemListener(this);
        this.data.setForeground(Color.black);
        this.average = new JCheckBox(JMeterUtils.getResString((String)"graph_results_average"));
        this.average.setSelected(true);
        this.average.addItemListener(this);
        this.average.setForeground(Color.blue);
        this.deviation = new JCheckBox(JMeterUtils.getResString((String)"graph_results_deviation"));
        this.deviation.setSelected(true);
        this.deviation.addItemListener(this);
        this.deviation.setForeground(Color.red);
        this.throughput = new JCheckBox(JMeterUtils.getResString((String)"graph_results_throughput"));
        this.throughput.setSelected(true);
        this.throughput.addItemListener(this);
        this.throughput.setForeground(JMeterColor.dark_green);
        chooseGraphsPanel.add(selectGraphsLabel);
        chooseGraphsPanel.add(this.data);
        chooseGraphsPanel.add(this.average);
        chooseGraphsPanel.add(this.deviation);
        chooseGraphsPanel.add(this.throughput);
        JScrollPane graphScrollPanel = new JScrollPane(this.graph, 21, 30);
        graphScrollPanel.setViewportBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JPanel graphYAxisPanel = new JPanel();
        graphYAxisPanel.setLayout(new BorderLayout());
        JPanel maxYPanel = new JPanel(new FlowLayout());
        JLabel maxYLabel = new JLabel(JMeterUtils.getResString((String)"graph_results_ms"));
        this.maxYField = new JTextField(5);
        this.maxYField.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.maxYField.setEditable(false);
        this.maxYField.setForeground(Color.black);
        this.maxYField.setBackground(this.getBackground());
        this.maxYField.setHorizontalAlignment(4);
        maxYPanel.add(this.maxYField);
        maxYPanel.add(maxYLabel);
        JPanel minYPanel = new JPanel(new FlowLayout());
        JLabel minYLabel = new JLabel(JMeterUtils.getResString((String)"graph_results_ms"));
        this.minYField = new JTextField(3);
        this.minYField.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.minYField.setEditable(false);
        this.minYField.setForeground(Color.black);
        this.minYField.setBackground(this.getBackground());
        this.minYField.setHorizontalAlignment(4);
        minYPanel.add(this.minYField);
        minYPanel.add(minYLabel);
        graphYAxisPanel.add((Component)maxYPanel, "North");
        graphYAxisPanel.add((Component)minYPanel, "South");
        JPanel dataPanel = new JPanel();
        JLabel dataLabel = new JLabel(JMeterUtils.getResString((String)"graph_results_latest_sample"));
        dataLabel.setForeground(Color.black);
        this.dataField = new JTextField(5);
        this.dataField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.dataField.setEditable(false);
        this.dataField.setForeground(Color.black);
        this.dataField.setBackground(this.getBackground());
        dataPanel.add(dataLabel);
        dataPanel.add(this.dataField);
        JPanel averagePanel = new JPanel();
        JLabel averageLabel = new JLabel(JMeterUtils.getResString((String)"graph_results_average"));
        averageLabel.setForeground(Color.blue);
        this.averageField = new JTextField(5);
        this.averageField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.averageField.setEditable(false);
        this.averageField.setForeground(Color.blue);
        this.averageField.setBackground(this.getBackground());
        averagePanel.add(averageLabel);
        averagePanel.add(this.averageField);
        JPanel deviationPanel = new JPanel();
        JLabel deviationLabel = new JLabel(JMeterUtils.getResString((String)"graph_results_deviation"));
        deviationLabel.setForeground(Color.red);
        this.deviationField = new JTextField(5);
        this.deviationField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.deviationField.setEditable(false);
        this.deviationField.setForeground(Color.red);
        this.deviationField.setBackground(this.getBackground());
        deviationPanel.add(deviationLabel);
        deviationPanel.add(this.deviationField);
        JPanel throughputPanel = new JPanel();
        JLabel throughputLabel = new JLabel(JMeterUtils.getResString((String)"graph_results_throughput"));
        throughputLabel.setForeground(JMeterColor.dark_green);
        this.throughputField = new JTextField(15);
        this.throughputField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.throughputField.setEditable(false);
        this.throughputField.setForeground(JMeterColor.dark_green);
        this.throughputField.setBackground(this.getBackground());
        throughputPanel.add(throughputLabel);
        throughputPanel.add(this.throughputField);
        JPanel noSamplesPanel = new JPanel();
        JLabel noSamplesLabel = new JLabel(JMeterUtils.getResString((String)"graph_results_no_samples"));
        this.noSamplesField = new JTextField(6);
        this.noSamplesField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.noSamplesField.setEditable(false);
        this.noSamplesField.setForeground(Color.black);
        this.noSamplesField.setBackground(this.getBackground());
        noSamplesPanel.add(noSamplesLabel);
        noSamplesPanel.add(this.noSamplesField);
        JPanel graphInfoPanel = new JPanel();
        graphInfoPanel.setLayout(new GridLayout(2, 3));
        graphInfoPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        graphInfoPanel.add(noSamplesPanel);
        graphInfoPanel.add(dataPanel);
        graphInfoPanel.add(averagePanel);
        graphInfoPanel.add(deviationPanel);
        graphInfoPanel.add(throughputPanel);
        JPanel graphPanel = new JPanel();
        graphPanel.setLayout(new BorderLayout());
        graphPanel.add((Component)graphYAxisPanel, "West");
        graphPanel.add((Component)chooseGraphsPanel, "North");
        graphPanel.add((Component)graphScrollPanel, "Center");
        graphPanel.add((Component)graphInfoPanel, "South");
        this.add(mainPanel, "North");
        this.add(graphPanel, "Center");
    }
}

