/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.ModelListener;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class MailerModel
extends AbstractTestElement
implements Serializable {
    private String addressie;
    private String fromAddress;
    private String smtpHost;
    private String failureSubject;
    private String successSubject;
    private long failureCount = 0L;
    private long successCount = 0L;
    private long failureLimit = 2L;
    private long successLimit = 2L;
    private boolean failureMsgSent = false;
    private boolean siteDown = false;
    private boolean successMsgSent = false;
    private Properties appProperties = JMeterUtils.getJMeterProperties();
    private static final String FROM_KEY = "MailerModel.fromAddress";
    private static final String TO_KEY = "MailerModel.addressie";
    private static final String HOST_KEY = "MailerModel.smtpHost";
    private static final String SUCCESS_KEY = "MailerModel.successSubject";
    private static final String FAILURE_KEY = "MailerModel.failureSubject";
    private static final String FAILURE_LIMIT_KEY = "MailerModel.failureLimit";
    private static final String SUCCESS_LIMIT_KEY = "MailerModel.successLimit";
    private static transient Logger log;
    ModelListener changeListener;

    public MailerModel() {
        try {
            this.successLimit = Long.parseLong(this.appProperties.getProperty("mailer.successlimit"));
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.failureLimit = Long.parseLong(this.appProperties.getProperty("mailer.failurelimit"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized boolean isFailing() {
        return this.failureCount > this.failureLimit;
    }

    public synchronized Vector getAddressVector() {
        String theAddressie = this.getToAddress();
        Vector<String> addressVector = new Vector<String>();
        if (theAddressie != null) {
            String addressSep = ",";
            StringTokenizer next = new StringTokenizer(theAddressie, addressSep);
            while (next.hasMoreTokens()) {
                String theToken = next.nextToken().trim();
                if (theToken.indexOf("@") <= 0) continue;
                addressVector.addElement(theToken);
            }
        } else {
            return new Vector(0);
        }
        return addressVector;
    }

    public synchronized void add(SampleResult sample) {
        Vector addressVector;
        if (!sample.isSuccessful()) {
            ++this.failureCount;
        } else {
            ++this.successCount;
        }
        if (this.isFailing() && !this.siteDown && !this.failureMsgSent && (addressVector = this.getAddressVector()).size() != 0) {
            try {
                this.sendMail(this.fromAddress, addressVector, this.failureSubject, "URL Failed: " + sample.getSampleLabel(), this.smtpHost);
            }
            catch (Exception e) {
                log.error("Problem sending mail", (Throwable)e);
            }
            this.siteDown = true;
            this.failureMsgSent = true;
            this.successCount = 0L;
        }
        if (this.siteDown && sample.getTime() != -1L & !this.successMsgSent && this.successCount > this.successLimit) {
            addressVector = this.getAddressVector();
            try {
                this.sendMail(this.fromAddress, addressVector, this.successSubject, "URL Restarted: " + sample.getSampleLabel(), this.smtpHost);
            }
            catch (Exception e) {
                log.error("Problem sending mail", (Throwable)e);
            }
            this.siteDown = false;
            this.successMsgSent = true;
        }
        if (this.successMsgSent && this.failureMsgSent) {
            this.clear();
        }
        this.notifyChangeListeners();
    }

    public synchronized void clear() {
        this.failureCount = 0L;
        this.successCount = 0L;
        this.siteDown = false;
        this.successMsgSent = false;
        this.failureMsgSent = false;
        this.notifyChangeListeners();
    }

    public String toString() {
        return "E-Mail Notification";
    }

    public synchronized void sendMail(String from, Vector vEmails, String subject, String attText, String smtpHost) throws UnknownHostException, AddressException, MessagingException {
        String host = smtpHost;
        boolean debug = Boolean.valueOf(host);
        InetAddress remote = InetAddress.getByName(host);
        InternetAddress[] address = new InternetAddress[vEmails.size()];
        int k = 0;
        while (k < vEmails.size()) {
            address[k] = new InternetAddress(vEmails.elementAt(k).toString());
            ++k;
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", host);
        Session session = Session.getDefaultInstance((Properties)props, null);
        session.setDebug(debug);
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(from));
        msg.setRecipients(Message.RecipientType.TO, (Address[])address);
        msg.setSubject(subject);
        msg.setText(attText);
        Transport.send((Message)msg);
    }

    public String getAttributesTitle() {
        return JMeterUtils.getResString((String)"mailer_attributes_panel");
    }

    public void setToAddress(String str) {
        this.addressie = str;
    }

    public void setFromAddress(String str) {
        this.fromAddress = str;
    }

    public void setSmtpHost(String str) {
        this.smtpHost = str;
    }

    public void setFailureSubject(String str) {
        this.failureSubject = str;
    }

    public void setSuccessSubject(String str) {
        this.successSubject = str;
    }

    public void setSuccessLimit(long limit) {
        this.successLimit = limit;
    }

    public void setSuccessCount(long count) {
        this.successCount = count;
    }

    public void setFailureLimit(long limit) {
        this.failureLimit = limit;
    }

    public void setFailureCount(long count) {
        this.failureCount = count;
    }

    public String getToAddress() {
        return this.addressie;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    public String getFailureSubject() {
        return this.failureSubject;
    }

    public String getSuccessSubject() {
        return this.successSubject;
    }

    public long getSuccessLimit() {
        return this.successLimit;
    }

    public long getSuccessCount() {
        return this.successCount;
    }

    public long getFailureLimit() {
        return this.failureLimit;
    }

    public long getFailureCount() {
        return this.failureCount;
    }

    public void storeModel(TestElement element) {
        element.setProperty(TO_KEY, (Object)this.getToAddress());
        element.setProperty(FROM_KEY, (Object)this.getFromAddress());
        element.setProperty(HOST_KEY, (Object)this.getSmtpHost());
        element.setProperty(SUCCESS_KEY, (Object)this.getSuccessSubject());
        element.setProperty(FAILURE_KEY, (Object)this.getFailureSubject());
        element.setProperty(FAILURE_LIMIT_KEY, (Object)new Long(this.getFailureLimit()));
        element.setProperty(SUCCESS_LIMIT_KEY, (Object)new Long(this.getSuccessLimit()));
    }

    public void retrieveModel(TestElement element) {
        try {
            this.setToAddress(element.getPropertyAsString(TO_KEY));
            this.setFromAddress(element.getPropertyAsString(FROM_KEY));
            this.setSmtpHost(element.getPropertyAsString(HOST_KEY));
            this.setSuccessSubject(element.getPropertyAsString(SUCCESS_KEY));
            this.setFailureSubject(element.getPropertyAsString(FAILURE_KEY));
            this.setFailureLimit(Long.parseLong((String)element.getProperty(FAILURE_LIMIT_KEY)));
            this.setSuccessLimit(Long.parseLong((String)element.getProperty(SUCCESS_LIMIT_KEY)));
        }
        catch (Exception e) {
            log.error("Couldn't load MailerVisualizer...");
        }
    }

    public void addModelListener(ModelListener listener) {
        this.changeListener = listener;
    }

    private void notifyChangeListeners() {
        this.changeListener.updateVisualizer();
    }

    private void notifyChangeListenersAboutMessage(String messageString) {
        this.changeListener.displayMessage(messageString, true);
    }

    static {
        FROM_KEY = FROM_KEY;
        TO_KEY = TO_KEY;
        HOST_KEY = HOST_KEY;
        SUCCESS_KEY = SUCCESS_KEY;
        FAILURE_KEY = FAILURE_KEY;
        FAILURE_LIMIT_KEY = FAILURE_LIMIT_KEY;
        SUCCESS_LIMIT_KEY = SUCCESS_LIMIT_KEY;
        log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.gui");
    }
}

