/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.UnknownHostException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.MailerModel;
import org.apache.jmeter.visualizers.ModelListener;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.jorphan.gui.layout.VerticalLayout;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class MailerVisualizer
extends AbstractVisualizer
implements ActionListener,
FocusListener,
Clearable,
ModelListener {
    private JButton testerButton;
    private JTextField addressField;
    private JTextField fromField;
    private JTextField smtpHostField;
    private JTextField failureSubjectField;
    private JTextField successSubjectField;
    private JTextField failureField;
    private JTextField failureLimitField;
    private JTextField successLimitField;
    private JPanel mainPanel;
    private JLabel panelTitleLabel;
    private MailerModel model = new MailerModel();
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.gui");

    public MailerVisualizer() {
        this.model.addModelListener(this);
        this.initGui();
    }

    public JPanel getControlPanel() {
        return this;
    }

    public synchronized void add(SampleResult sample) {
        this.model.add(sample);
    }

    public synchronized void clear() {
        this.model.clear();
    }

    public String toString() {
        return "E-Mail Notification";
    }

    private void initGui() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 2, 1));
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
        JLabel panelTitleLabel = new JLabel(this.getStaticLabel());
        Font curFont = panelTitleLabel.getFont();
        int curFontSize = curFont.getSize();
        panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
        mainPanel.add(panelTitleLabel);
        mainPanel.add((Component)this.getNamePanel());
        JPanel mailerPanel = new JPanel();
        mailerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.model.getAttributesTitle()));
        GridBagLayout g = new GridBagLayout();
        mailerPanel.setLayout(g);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridwidth = 1;
        mailerPanel.add(new JLabel("From:"));
        this.fromField = new JTextField(this.model.getFromAddress(), 25);
        this.fromField.setEditable(true);
        this.fromField.addActionListener(this);
        this.fromField.addFocusListener(this);
        c.gridwidth = 0;
        g.setConstraints(this.fromField, c);
        mailerPanel.add(this.fromField);
        c.anchor = 18;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridwidth = 1;
        mailerPanel.add(new JLabel("Addressie(s):"));
        this.addressField = new JTextField(this.model.getToAddress(), 25);
        this.addressField.setEditable(true);
        this.addressField.addActionListener(this);
        this.addressField.addFocusListener(this);
        c.gridwidth = 0;
        g.setConstraints(this.addressField, c);
        mailerPanel.add(this.addressField);
        c.gridwidth = 1;
        mailerPanel.add(new JLabel("SMTP Host:"));
        this.smtpHostField = new JTextField(this.model.getSmtpHost(), 25);
        this.smtpHostField.setEditable(true);
        this.smtpHostField.addActionListener(this);
        this.smtpHostField.addFocusListener(this);
        c.gridwidth = 0;
        g.setConstraints(this.smtpHostField, c);
        mailerPanel.add(this.smtpHostField);
        c.gridwidth = 1;
        mailerPanel.add(new JLabel("Failure Subject:"));
        this.failureSubjectField = new JTextField(this.model.getFailureSubject(), 25);
        this.failureSubjectField.setEditable(true);
        this.failureSubjectField.addActionListener(this);
        this.failureSubjectField.addFocusListener(this);
        c.gridwidth = 0;
        g.setConstraints(this.failureSubjectField, c);
        mailerPanel.add(this.failureSubjectField);
        c.gridwidth = 1;
        mailerPanel.add(new JLabel("Success Subject:"));
        this.successSubjectField = new JTextField(this.model.getSuccessSubject(), 25);
        this.successSubjectField.setEditable(true);
        this.successSubjectField.addActionListener(this);
        this.successSubjectField.addFocusListener(this);
        c.gridwidth = 0;
        g.setConstraints(this.successSubjectField, c);
        mailerPanel.add(this.successSubjectField);
        c.gridwidth = 1;
        mailerPanel.add(new JLabel("Failure Limit:"));
        this.failureLimitField = new JTextField(Long.toString(this.model.getFailureLimit()), 6);
        this.failureLimitField.setEditable(true);
        this.failureLimitField.addActionListener(this);
        this.failureLimitField.addFocusListener(this);
        c.gridwidth = 0;
        g.setConstraints(this.failureLimitField, c);
        mailerPanel.add(this.failureLimitField);
        c.gridwidth = 1;
        mailerPanel.add(new JLabel("Success Limit:"));
        this.successLimitField = new JTextField(Long.toString(this.model.getSuccessLimit()), 6);
        this.successLimitField.setEditable(true);
        this.successLimitField.addActionListener(this);
        this.successLimitField.addFocusListener(this);
        c.gridwidth = 0;
        g.setConstraints(this.successLimitField, c);
        mailerPanel.add(this.successLimitField);
        this.testerButton = new JButton("Test Mail");
        this.testerButton.addActionListener(this);
        this.testerButton.setEnabled(true);
        c.gridwidth = 1;
        g.setConstraints(this.testerButton, c);
        mailerPanel.add(this.testerButton);
        c.gridwidth = 1;
        mailerPanel.add(new JLabel("Failures:"));
        this.failureField = new JTextField(6);
        this.failureField.setEditable(false);
        this.failureField.addActionListener(this);
        c.gridwidth = 0;
        g.setConstraints(this.failureField, c);
        mailerPanel.add(this.failureField);
        mainPanel.add((Component)mailerPanel, "Center");
        this.add(mainPanel);
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"mailer_visualizer_title");
    }

    public String getAttributesTitle() {
        return JMeterUtils.getResString((String)"mailer_attributes_panel");
    }

    private void doEventHandling(Object source) {
        if (source == this.addressField) {
            this.model.setToAddress(this.addressField.getText());
        } else if (source == this.fromField) {
            this.model.setFromAddress(this.fromField.getText());
        } else if (source == this.smtpHostField) {
            this.model.setSmtpHost(this.smtpHostField.getText());
        } else if (source == this.failureSubjectField) {
            this.model.setFailureSubject(this.failureSubjectField.getText());
        } else if (source == this.successSubjectField) {
            this.model.setSuccessSubject(this.successSubjectField.getText());
        } else if (source == this.failureLimitField) {
            try {
                this.model.setFailureLimit(Long.parseLong(this.failureLimitField.getText()));
            }
            catch (NumberFormatException e) {
                log.warn("failureLimitField=" + this.failureLimitField.getText(), (Throwable)e);
                JOptionPane.showMessageDialog(null, JMeterUtils.getResString((String)"you_must_enter_a_valid_number"), "Error", 0);
            }
        } else if (source == this.successLimitField) {
            try {
                this.model.setSuccessLimit(Long.parseLong(this.successLimitField.getText()));
            }
            catch (NumberFormatException e) {
                log.warn("successLimitField=" + this.successLimitField.getText(), (Throwable)e);
                JOptionPane.showMessageDialog(null, JMeterUtils.getResString((String)"you_must_enter_a_valid_number"), "Error", 0);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            JComponent c = (JComponent)e.getSource();
            if (c == this.testerButton) {
                String testString = "JMeter-Testmail\nTo:  " + this.model.getToAddress() + "\n" + "Via:  " + this.model.getSmtpHost() + "\n" + "Fail Subject:  " + this.model.getFailureSubject() + "\n" + "Success Subject:  " + this.model.getSuccessSubject();
                log.debug(testString);
                this.model.sendMail(this.model.getFromAddress(), this.model.getAddressVector(), "Testing mail-addresses", testString, this.model.getSmtpHost());
                log.info("Mail sent successfully!!");
            } else {
                this.doEventHandling(c);
            }
        }
        catch (UnknownHostException e1) {
            log.error("Invalid Mail Server ", (Throwable)e1);
            this.displayMessage(JMeterUtils.getResString((String)"invalid_mail_server"), true);
        }
        catch (Exception ex) {
            log.error("Couldn't send mail...", (Throwable)ex);
            this.displayMessage(JMeterUtils.getResString((String)"invalid_mail_server"), true);
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        Object source = e.getSource();
        this.doEventHandling(source);
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.model.retrieveModel(el);
        this.updateVisualizer();
    }

    public TestElement createTestElement() {
        TestElement element = super.createTestElement();
        this.model.storeModel(element);
        return element;
    }

    public void updateVisualizer() {
        this.addressField.setText(this.model.getToAddress());
        this.fromField.setText(this.model.getFromAddress());
        this.smtpHostField.setText(this.model.getSmtpHost());
        this.successSubjectField.setText(this.model.getSuccessSubject());
        this.failureSubjectField.setText(this.model.getFailureSubject());
        this.failureLimitField.setText(String.valueOf(this.model.getFailureLimit()));
        this.failureField.setText(String.valueOf(this.model.getFailureCount()));
        this.successLimitField.setText(String.valueOf(this.model.getSuccessLimit()));
        this.repaint();
    }

    public void displayMessage(String message, boolean isError) {
        int type = 0;
        type = isError ? 0 : 1;
        JOptionPane.showMessageDialog(null, message, "Error", type);
    }
}

