/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.text.DecimalFormat;
import org.apache.jmeter.samplers.SampleResult;

public class RunningSample {
    private static DecimalFormat rateFormatter = new DecimalFormat("#.0");
    private static DecimalFormat errorFormatter = new DecimalFormat("#0.00%");
    private long counter;
    private long runningSum;
    private long max;
    private long min;
    private long errorCount;
    private long firstTime;
    private long lastTime;
    private String label;
    private int index;

    public RunningSample(String label, int index) {
        this.label = label;
        this.index = index;
        this.counter = 0L;
        this.runningSum = 0L;
        this.max = Long.MIN_VALUE;
        this.min = Long.MAX_VALUE;
        this.errorCount = 0L;
        this.firstTime = 0L;
        this.lastTime = 0L;
    }

    public double getRate() {
        long howLongRunning = this.lastTime - this.firstTime;
        if (howLongRunning == 0L) {
            return Double.MAX_VALUE;
        }
        return (double)this.counter / (double)howLongRunning * 1000.0;
    }

    public double getRatePerMin() {
        long howLongRunning = this.lastTime - this.firstTime;
        if (howLongRunning == 0L) {
            return Double.MAX_VALUE;
        }
        return (double)this.counter / (double)howLongRunning * 60000.0;
    }

    public String getRateString() {
        double rate = this.getRate();
        if (rate == Double.MAX_VALUE) {
            return "N/A";
        }
        String unit = "sec";
        if (rate < 1.0) {
            rate *= 60.0;
            unit = "min";
        }
        if (rate < 1.0) {
            rate *= 60.0;
            unit = "/hour";
        }
        String rval = rateFormatter.format(rate) + "/" + unit;
        return rval;
    }

    public String getLabel() {
        return this.label;
    }

    public int getIndex() {
        return this.index;
    }

    public synchronized void addSample(SampleResult res) {
        long aTimeInMillis = res.getTime();
        boolean aSuccessFlag = res.isSuccessful();
        this.lastTime = res.getTimeStamp();
        ++this.counter;
        if (this.firstTime == 0L) {
            this.firstTime = this.lastTime;
        }
        this.runningSum += aTimeInMillis;
        if (aTimeInMillis > this.max) {
            this.max = aTimeInMillis;
        }
        if (aTimeInMillis < this.min) {
            this.min = aTimeInMillis;
        }
        if (!aSuccessFlag) {
            ++this.errorCount;
        }
    }

    public long getMin() {
        long rval = 0L;
        if (this.min != Long.MAX_VALUE) {
            rval = this.min;
        }
        return rval;
    }

    public long getMax() {
        long rval = 0L;
        if (this.max != Long.MIN_VALUE) {
            rval = this.max;
        }
        return rval;
    }

    public long getAverage() {
        if (this.counter == 0L) {
            return 0L;
        }
        return this.runningSum / this.counter;
    }

    public long getNumSamples() {
        return this.counter;
    }

    public double getErrorPercentage() {
        double rval = 0.0;
        if (this.counter == 0L) {
            return rval;
        }
        rval = (double)this.errorCount / (double)this.counter;
        return rval;
    }

    public String getErrorPercentageString() {
        double myErrorPercentage = this.getErrorPercentage();
        return errorFormatter.format(myErrorPercentage);
    }

    public String toString() {
        StringBuffer mySB = new StringBuffer();
        mySB.append("Samples: " + this.getNumSamples() + "  ");
        mySB.append("Avg: " + this.getAverage() + "  ");
        mySB.append("Min: " + this.getMin() + "  ");
        mySB.append("Max: " + this.getMax() + "  ");
        mySB.append("Error Rate: " + this.getErrorPercentageString() + "  ");
        mySB.append("Sample Rate: " + this.getRateString());
        return mySB.toString();
    }
}

