/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

class SortFilterModel
extends AbstractTableModel {
    private TableModel model;
    private int sortColumn;
    private Row[] rows;

    public SortFilterModel(TableModel m) {
        this.model = m;
        this.rows = new Row[this.model.getRowCount()];
        int i = 0;
        while (i < this.rows.length) {
            this.rows[i] = new Row();
            this.rows[i].index = i;
            ++i;
        }
    }

    public SortFilterModel() {
    }

    public void setValueAt(Object aValue, int r, int c) {
        this.model.setValueAt(aValue, this.rows[r].index, c);
    }

    public Object getValueAt(int r, int c) {
        return this.model.getValueAt(this.rows[r].index, c);
    }

    public boolean isCellEditable(int r, int c) {
        return this.model.isCellEditable(this.rows[r].index, c);
    }

    public int getRowCount() {
        return this.model.getRowCount();
    }

    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    public String getColumnName(int c) {
        return this.model.getColumnName(c);
    }

    public Class getColumnClass(int c) {
        return this.model.getColumnClass(c);
    }

    public void sort(int c) {
        this.sortColumn = c;
        Arrays.sort(this.rows);
        this.fireTableDataChanged();
    }

    public void addMouseListener(final JTable table) {
        table.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() < 2) {
                    return;
                }
                int tableColumn = table.columnAtPoint(event.getPoint());
                int modelColumn = table.convertColumnIndexToModel(tableColumn);
                SortFilterModel.this.sort(modelColumn);
            }
        });
    }

    private class Row
    implements Comparable {
        public int index;

        private Row() {
        }

        public int compareTo(Object other) {
            Row otherRow = (Row)other;
            Object a = SortFilterModel.this.model.getValueAt(this.index, SortFilterModel.this.sortColumn);
            Object b = SortFilterModel.this.model.getValueAt(otherRow.index, SortFilterModel.this.sortColumn);
            if (a instanceof Comparable) {
                return ((Comparable)a).compareTo(b);
            }
            return this.index - otherRow.index;
        }
    }
}

