/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class Spline3 {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.gui");
    protected float[][] _coefficients;
    protected float[][] _A;
    protected float[] _B;
    protected float[] _r;
    protected float[] _rS;
    protected int _m;
    protected int _n;
    protected static final float DEFAULT_PRECISION = 0.1f;
    protected static final int DEFAULT_MAX_ITERATIONS = 100;
    protected float _minPrecision = 0.1f;
    protected int _maxIterations = 100;

    public Spline3(float[] r) {
        int n;
        this._m = n = r.length;
        this._r = new float[n];
        int i = 0;
        while (i < n) {
            this._r[i] = r[i];
            ++i;
        }
        this._n = n - 2;
        try {
            long startTime = System.currentTimeMillis();
            this.interpolation();
            if (log.isDebugEnabled()) {
                long endTime = System.currentTimeMillis();
                long elapsedTime = endTime - startTime;
                log.debug("New Spline curve interpolated in ");
                log.debug(elapsedTime + " ms");
            }
        }
        catch (Exception e) {
            log.error("Error when interpolating : ", (Throwable)e);
        }
    }

    protected void interpolation() {
        this._rS = new float[this._m];
        this._B = new float[this._n];
        this._A = new float[this._n][this._n];
        this._coefficients = new float[this._n + 1][4];
        int i = 0;
        int j = 0;
        i = 0;
        while (i < this._n) {
            this._B[i] = 0.0f;
            j = 0;
            while (j < this._n) {
                this._A[i][j] = 0.0f;
                ++j;
            }
            j = 0;
            while (j < 4) {
                this._coefficients[i][j] = 0.0f;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this._n) {
            this._rS[i] = 0.0f;
            ++i;
        }
        i = 0;
        while (i < this._n) {
            this._A[i][i] = 4.0f;
            ++i;
        }
        i = 1;
        while (i < this._n) {
            this._A[i][i - 1] = 1.0f;
            this._A[i - 1][i] = 1.0f;
            ++i;
        }
        i = 0;
        while (i < this._n) {
            this._B[i] = 6.0f * (this._r[i + 2] - 2.0f * this._r[i + 1] + this._r[i]);
            ++i;
        }
        this.jacobi();
        i = 0;
        while (i < this._n + 1) {
            this._coefficients[i][0] = this._r[i];
            this._coefficients[i][1] = this._r[i + 1] - this._r[i] - (this._rS[i + 1] + 2.0f * this._rS[i]) / 6.0f;
            this._coefficients[i][2] = this._rS[i] / 2.0f;
            this._coefficients[i][3] = (this._rS[i + 1] - this._rS[i]) / 6.0f;
            ++i;
        }
    }

    protected void jacobi() {
        int i = 0;
        int j = 0;
        int iterations = 0;
        float[] newX = new float[this._n];
        float[] oldX = new float[this._n];
        if (!this.converge() && log.isDebugEnabled()) {
            log.debug("Warning : equation system resolving is unstable");
        }
        i = 0;
        while (i < this._n) {
            newX[i] = 0.0f;
            oldX[i] = 0.0f;
            ++i;
        }
        while (this.precision(oldX, newX) > this._minPrecision && iterations < this._maxIterations) {
            i = 0;
            while (i < this._n) {
                oldX[i] = newX[i];
                ++i;
            }
            i = 0;
            while (i < this._n) {
                newX[i] = this._B[i];
                j = 0;
                while (j < i) {
                    newX[i] = newX[i] - this._A[i][j] * oldX[j];
                    ++j;
                }
                j = i + 1;
                while (j < this._n) {
                    newX[i] = newX[i] - this._A[i][j] * oldX[j];
                    ++j;
                }
                newX[i] = newX[i] / this._A[i][i];
                ++i;
            }
            ++iterations;
        }
        if (this.precision(oldX, newX) < this._minPrecision) {
            if (log.isDebugEnabled()) {
                log.debug("Minimal precision (");
                log.debug(this._minPrecision + ") reached after ");
                log.debug(iterations + " iterations");
            }
        } else if (iterations > this._maxIterations && log.isDebugEnabled()) {
            log.debug("Maximal number of iterations (");
            log.debug(this._maxIterations + ") reached");
            log.debug("Warning : precision is only ");
            log.debug("" + this.precision(oldX, newX));
            log.debug(", divergence is possible");
        }
        i = 0;
        while (i < this._n) {
            this._rS[i + 1] = newX[i];
            ++i;
        }
    }

    protected boolean converge() {
        boolean converge = true;
        int i = 0;
        int j = 0;
        float lineSum = 0.0f;
        i = 0;
        while (i < this._n) {
            if (converge) {
                lineSum = 0.0f;
                j = 0;
                while (j < this._n) {
                    lineSum += Math.abs(this._A[i][j]);
                    ++j;
                }
                if ((lineSum -= Math.abs(this._A[i][i])) > Math.abs(this._A[i][i])) {
                    converge = false;
                }
            }
            ++i;
        }
        return converge;
    }

    protected float precision(float[] oldX, float[] newX) {
        float N = 0.0f;
        float D = 0.0f;
        float erreur = 0.0f;
        int i = 0;
        i = 0;
        while (i < this._n) {
            N += Math.abs(newX[i] - oldX[i]);
            D += Math.abs(newX[i]);
            ++i;
        }
        erreur = D != 0.0f ? N / D : Float.MAX_VALUE;
        return erreur;
    }

    public float value(float t) {
        int i = 0;
        int splineNumber = 0;
        float abscissa = 0.0f;
        float result = 0.0f;
        if (t < 0.0f || t > (float)(this._m - 1)) {
            if (log.isDebugEnabled()) {
                log.debug("Warning : abscissa " + t + " out of bounds [0, " + (this._m - 1) + "]");
            }
            t = t < 0.0f ? 0.0f : (float)(this._m - 1);
        }
        splineNumber = (int)Math.floor(t);
        if (t == (float)(this._m - 1)) {
            --splineNumber;
        }
        abscissa = t - (float)splineNumber;
        i = 0;
        while (i < 4) {
            result *= abscissa;
            result += this._coefficients[splineNumber][3 - i];
            ++i;
        }
        return result;
    }

    public void debugCheck() {
        int i = 0;
        i = 0;
        while (i < this._m) {
            log.info("Point " + i + " : ");
            log.info(this._r[i] + " =? " + this.value(i));
            ++i;
        }
    }

    public int[] getPlots(int width, int height) {
        int[] plot = new int[width];
        float[] y = new float[width];
        float max = -2.1474836E9f;
        float min = 2.1474836E9f;
        int i = 0;
        while (i < width) {
            y[i] = this.value((float)i * (float)(this._m - 1) / (float)width);
            if (y[i] < min) {
                min = y[i];
            }
            if (y[i] > max) {
                max = y[i];
            }
            ++i;
        }
        if (min < 0.0f) {
            min = 0.0f;
        }
        int i2 = 0;
        while (i2 < width) {
            plot[i2] = Math.round((y[i2] - min) * (float)(height - 1) / (max - min));
            ++i2;
        }
        return plot;
    }

    public void setPrecision(float precision) {
        this._minPrecision = precision;
    }

    public float getPrecision() {
        return this._minPrecision;
    }

    public void setToDefaultPrecision() {
        this._minPrecision = 0.1f;
    }

    public float getDefaultPrecision() {
        return 0.1f;
    }

    public void setMaxIterations(int iterations) {
        this._maxIterations = iterations;
    }

    public int getMaxIterations() {
        return this._maxIterations;
    }

    public void setToDefaultMaxIterations() {
        this._maxIterations = 100;
    }

    public int getDefaultMaxIterations() {
        return 100;
    }

    static {
        DEFAULT_PRECISION = 0.1f;
        DEFAULT_MAX_ITERATIONS = 100;
    }
}

