/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.GraphListener;
import org.apache.jmeter.visualizers.Spline3;

public class SplineModel
implements Clearable {
    public final int DEFAULT_NUMBER_OF_NODES = 10;
    public final int DEFAULT_REFRESH_PERIOD = 1;
    protected final boolean SHOW_INCOMING_SAMPLES = true;
    protected int numberOfNodes = 10;
    protected int refreshPeriod = 1;
    protected Spline3 dataCurve = null;
    protected long sum = 0L;
    protected long average = 0L;
    protected long n = 0L;
    ArrayList samples;
    private GraphListener listener;
    private long minimum = Integer.MAX_VALUE;
    private long maximum = Integer.MIN_VALUE;
    private long incoming;
    private String name;
    static /* synthetic */ Class class$org$apache$jmeter$visualizers$SplineVisualizer;

    public SplineModel() {
        this.samples = new ArrayList();
    }

    public void setListener(GraphListener vis) {
        this.listener = vis;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public boolean isEditable() {
        return true;
    }

    public Spline3 getDataCurve() {
        return this.dataCurve;
    }

    public Class getGuiClass() {
        return class$org$apache$jmeter$visualizers$SplineVisualizer == null ? (class$org$apache$jmeter$visualizers$SplineVisualizer = SplineModel.class$("org.apache.jmeter.visualizers.SplineVisualizer")) : class$org$apache$jmeter$visualizers$SplineVisualizer;
    }

    public Collection getAddList() {
        return null;
    }

    public String getClassLabel() {
        return JMeterUtils.getResString((String)"spline_visualizer_title");
    }

    public long getMinimum() {
        return this.minimum;
    }

    public long getMaximum() {
        return this.maximum;
    }

    public long getAverage() {
        return this.average;
    }

    public long getCurrent() {
        return this.incoming;
    }

    public long[] getSamples() {
        int n = this.samples.size();
        long[] longSample = new long[n];
        int i = 0;
        while (i < n) {
            longSample[i] = (Long)this.samples.get(i);
            ++i;
        }
        return longSample;
    }

    public long getSample(int i) {
        Long sample = (Long)this.samples.get(i);
        return sample;
    }

    public int getNumberOfCollectedSamples() {
        return this.samples.size();
    }

    public String getName() {
        return this.name;
    }

    public void uncompile() {
        this.clear();
    }

    public synchronized void clear() {
        this.samples.clear();
        this.n = 0L;
        this.sum = 0L;
        this.average = 0L;
        this.minimum = Integer.MAX_VALUE;
        this.maximum = Integer.MIN_VALUE;
        this.dataCurve = null;
        if (this.listener != null) {
            this.listener.updateGui();
        }
    }

    public synchronized void add(SampleResult sampleResult) {
        long sample = sampleResult.getTime();
        ++this.n;
        this.sum += sample;
        this.average = this.sum / this.n;
        this.incoming = sample;
        if (sample > this.maximum) {
            this.maximum = sample;
        }
        if (sample < this.minimum) {
            this.minimum = sample;
        }
        this.samples.add(new Long(sample));
        int n = this.getNumberOfCollectedSamples();
        if (n % (this.numberOfNodes * this.refreshPeriod) == 0) {
            float[] floatNode = new float[this.numberOfNodes];
            long[] longSample = this.getSamples();
            int loadFactor = n / this.numberOfNodes;
            int i = 0;
            while (i < this.numberOfNodes) {
                int j = 0;
                while (j < loadFactor) {
                    int n2 = i;
                    floatNode[n2] = floatNode[n2] + (float)this.getSample(i * loadFactor + j);
                    ++j;
                }
                floatNode[i] = floatNode[i] / (float)loadFactor;
                ++i;
            }
            this.dataCurve = new Spline3(floatNode);
            if (this.listener != null) {
                this.listener.updateGui();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

