/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.visualizers.AccumListener;
import org.apache.jmeter.visualizers.GraphListener;
import org.apache.jmeter.visualizers.RunningSample;

public class StatVisualizerModel
implements Clearable {
    private String name;
    private List listeners = new LinkedList();
    private Vector runningSamples = new Vector(0, 10);
    private Map labelMap = Collections.synchronizedMap(new HashMap(10));
    private RunningSample total = new RunningSample("__TOTAL__", -1);
    static /* synthetic */ Class class$org$apache$jmeter$visualizers$StatVisualizer;

    public void setName(String name) {
        this.name = name;
    }

    public Class getGuiClass() {
        return class$org$apache$jmeter$visualizers$StatVisualizer == null ? (class$org$apache$jmeter$visualizers$StatVisualizer = StatVisualizerModel.class$("org.apache.jmeter.visualizers.StatVisualizer")) : class$org$apache$jmeter$visualizers$StatVisualizer;
    }

    public String getName() {
        return this.name;
    }

    public void addGraphListener(GraphListener listener) {
        this.listeners.add(listener);
    }

    public void addAccumListener(AccumListener listener) {
        this.listeners.add(listener);
    }

    public int getRunningSampleCount() {
        return this.runningSamples.size();
    }

    public RunningSample getRunningSample(int index) {
        return (RunningSample)this.runningSamples.get(index);
    }

    public RunningSample getRunningSample(String label) {
        return (RunningSample)this.labelMap.get(label);
    }

    public RunningSample getRunningSampleTotal() {
        return this.total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewSample(SampleResult res) {
        RunningSample s;
        String aLabel = res.getSampleLabel();
        String responseCode = res.getResponseCode();
        Map map = this.labelMap;
        synchronized (map) {
            s = (RunningSample)this.labelMap.get(aLabel);
            if (s == null) {
                s = new RunningSample(aLabel, this.runningSamples.size());
                this.runningSamples.add(s);
                this.labelMap.put(aLabel, s);
            }
        }
        s.addSample(res);
        this.total.addSample(res);
        this.fireDataChanged(s);
    }

    public void clear() {
        this.runningSamples.clear();
        this.labelMap.clear();
        this.total = new RunningSample("__TOTAL__", -1);
        this.fireDataChanged();
    }

    protected void fireDataChanged() {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            Object myObj = iter.next();
            if (!(myObj instanceof GraphListener)) continue;
            ((GraphListener)myObj).updateGui();
        }
    }

    protected void fireDataChanged(RunningSample s) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            Object myObj = iter.next();
            if (!(myObj instanceof AccumListener)) continue;
            ((AccumListener)myObj).updateGui(s);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Test
    extends TestCase {
        public Test(String name) {
            super(name);
        }

        private SampleResult sample(String label, long timestamp, long time, boolean ok) {
            SampleResult res = new SampleResult();
            res.setSampleLabel(label);
            res.setTimeStamp(timestamp);
            res.setTime(time);
            res.setSuccessful(ok);
            return res;
        }

        public void testStatisticsCalculation() {
            StatVisualizerModel m = new StatVisualizerModel();
            long t0 = System.currentTimeMillis();
            m.addNewSample(this.sample("1", t0 + 0L, 100L, true));
            m.addNewSample(this.sample("2", t0 + 250L, 200L, true));
            m.addNewSample(this.sample("1", t0 + 500L, 300L, true));
            Assert.assertEquals((int)2, (int)m.getRunningSampleCount());
            Assert.assertEquals((int)2, (int)m.labelMap.size());
            RunningSample s = m.getRunningSample("1");
            Assert.assertEquals((Object)"1", (Object)s.getLabel());
            Assert.assertEquals((long)2L, (long)s.getNumSamples());
            Assert.assertEquals((long)100L, (long)s.getMin());
            Assert.assertEquals((long)300L, (long)s.getMax());
            Assert.assertEquals((long)200L, (long)s.getAverage());
            Assert.assertEquals((double)4.0, (double)s.getRate(), (double)1.0E-6);
            s = m.getRunningSample("2");
            Assert.assertEquals((Object)"2", (Object)s.getLabel());
            Assert.assertEquals((long)1L, (long)s.getNumSamples());
            Assert.assertEquals((long)200L, (long)s.getMin());
            Assert.assertEquals((long)200L, (long)s.getMax());
            Assert.assertEquals((long)200L, (long)s.getAverage());
            s = m.getRunningSampleTotal();
            Assert.assertEquals((long)3L, (long)s.getNumSamples());
            Assert.assertEquals((long)100L, (long)s.getMin());
            Assert.assertEquals((long)300L, (long)s.getMax());
            Assert.assertEquals((long)200L, (long)s.getAverage());
            Assert.assertEquals((double)6.0, (double)s.getRate(), (double)1.0E-6);
        }
    }
}

