/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public abstract class TreeVisualizer
extends JPanel
implements TreeSelectionListener,
Clearable {
    protected DefaultMutableTreeNode root;
    protected DefaultTreeModel treeModel;
    protected GridBagLayout gridBag;
    protected GridBagConstraints gbc;
    protected JPanel resultPanel;
    protected JScrollPane treePane;
    protected JScrollPane resultPane;
    protected JSplitPane treeSplitPane;
    protected JTree jTree;
    protected int childIndex;
    ResultCollector model;
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.gui");

    public TreeVisualizer() {
        this.setLayout(new GridLayout(1, 1));
        log.debug("Start : TreeVisualizer1");
        log.debug("End : TreeVisualizer1");
    }

    public void setModel(Object model) {
        log.debug("Start : setModel1");
        this.model = (ResultCollector)model;
        this.model.setListener((Object)this);
        this.init();
        log.debug("End : setModel1");
    }

    public abstract void updateGui();

    public abstract void valueChanged(TreeSelectionEvent var1);

    public void clear() {
        log.debug("Start : clear1");
        int totalChild = this.root.getChildCount();
        if (log.isDebugEnabled()) {
            log.debug("clear1 : total child - " + totalChild);
        }
        int i = 0;
        while (i < totalChild) {
            this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)this.root.getChildAt(0));
            ++i;
        }
        this.resultPanel.removeAll();
        this.resultPanel.repaint();
        this.childIndex = 0;
        log.debug("End : clear1");
    }

    public abstract String toString();

    protected void init() {
        log.debug("Start : init1");
        SampleResult rootSampleResult = new SampleResult();
        rootSampleResult.setSampleLabel("Root");
        this.root = new DefaultMutableTreeNode(rootSampleResult);
        this.treeModel = new DefaultTreeModel(this.root);
        this.jTree = new JTree(this.treeModel);
        this.jTree.getSelectionModel().setSelectionMode(1);
        this.jTree.addTreeSelectionListener(this);
        this.treePane = new JScrollPane(this.jTree);
        this.gridBag = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.resultPanel = new JPanel(this.gridBag);
        this.resultPanel.setPreferredSize(new Dimension(2000, 800));
        this.resultPane = new JScrollPane(this.resultPanel);
        this.treeSplitPane = new JSplitPane(0, this.treePane, this.resultPane);
        this.add(this.treeSplitPane);
        log.debug("End : init1");
    }
}

