/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.jorphan.gui.JLabeledTextArea;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ViewResultsFullVisualizer
extends AbstractVisualizer
implements ActionListener,
TreeSelectionListener,
Clearable {
    public static final Color SERVER_ERROR_COLOR = Color.red;
    public static final Color CLIENT_ERROR_COLOR = Color.blue;
    public static final Color REDIRECT_COLOR = Color.green;
    protected static final String HTML_BUTTON_LABEL = "Render HTML";
    protected static final String TEXT_BUTTON_LABEL = "Show Text";
    protected DefaultMutableTreeNode root;
    protected DefaultTreeModel treeModel;
    protected GridBagLayout gridBag;
    protected GridBagConstraints gbc;
    protected JButton htmlOrTextButton;
    protected String response;
    protected transient JEditorPane htmlEditPane;
    protected JPanel resultPanel;
    protected JScrollPane treePane;
    protected JScrollPane resultPane;
    protected JSplitPane treeSplitPane;
    protected JTextArea textArea;
    protected JTree jTree;
    protected int childIndex;
    private static transient Logger log;

    public ViewResultsFullVisualizer() {
        this.init();
        log.debug("Start : ViewResultsFullVisualizer1");
        log.debug("End : ViewResultsFullVisualizer1");
    }

    public void add(SampleResult res) {
        this.updateGui(res);
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"view_results_tree_title");
    }

    public void updateGui(SampleResult res) {
        log.debug("Start : updateGui1");
        if (log.isDebugEnabled()) {
            log.debug("updateGui1 : sample result - " + res);
        }
        DefaultMutableTreeNode currNode = new DefaultMutableTreeNode(res);
        this.treeModel.insertNodeInto(currNode, this.root, this.root.getChildCount());
        this.addSubResults(currNode, res);
        log.debug("End : updateGui1");
    }

    private void addSubResults(DefaultMutableTreeNode currNode, SampleResult res) {
        SampleResult[] subResults = res.getSubResults();
        if (subResults != null) {
            int leafIndex = 0;
            int i = 0;
            while (i < subResults.length) {
                SampleResult child = subResults[i];
                if (log.isDebugEnabled()) {
                    log.debug("updateGui1 : child sample result - " + child);
                }
                DefaultMutableTreeNode leafNode = new DefaultMutableTreeNode(child);
                this.treeModel.insertNodeInto(leafNode, currNode, leafIndex++);
                this.addSubResults(leafNode, child);
                ++i;
            }
        }
    }

    public void clear() {
        log.debug("Start : clear1");
        int totalChild = this.root.getChildCount();
        if (log.isDebugEnabled()) {
            log.debug("clear1 : total child - " + totalChild);
        }
        int i = 0;
        while (i < totalChild) {
            this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)this.root.getChildAt(0));
            ++i;
        }
        this.resultPanel.removeAll();
        this.resultPanel.revalidate();
        this.childIndex = 0;
        log.debug("End : clear1");
    }

    public String toString() {
        String desc = "Shows the text results of sampling in tree form";
        if (log.isDebugEnabled()) {
            log.debug("toString1 : Returning description - " + desc);
        }
        return desc;
    }

    public void valueChanged(TreeSelectionEvent e) {
        log.debug("Start : valueChanged1");
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jTree.getLastSelectedPathComponent();
        if (log.isDebugEnabled()) {
            log.debug("valueChanged : selected node - " + node);
        }
        if (node != null) {
            SampleResult res = (SampleResult)node.getUserObject();
            if (log.isDebugEnabled()) {
                log.debug("valueChanged1 : sample result - " + res);
            }
            if (res != null) {
                this.resultPanel.removeAll();
                JLabel loadTime = new JLabel();
                log.debug("valueChanged1 : load time - " + res.getTime());
                loadTime.setText("Load time : " + res.getTime());
                this.gbc.gridx = 0;
                this.gbc.gridy = 0;
                this.gbc.anchor = 17;
                this.gbc.weightx = 1.0;
                this.gbc.insets = new Insets(0, 10, 0, 0);
                if (res != null && res.getSamplerData() != null) {
                    JLabeledTextArea postData = new JLabeledTextArea(JMeterUtils.getResString((String)"request_data"), null);
                    postData.setText(res.getSamplerData().toString());
                    this.resultPanel.add((Component)postData, this.gbc.clone());
                    ++this.gbc.gridy;
                }
                this.resultPanel.add((Component)loadTime, this.gbc.clone());
                JLabel httpResponseCode = new JLabel();
                String responseCode = res.getResponseCode();
                log.debug("valueChanged1 : response code - " + responseCode);
                int responseLevel = 0;
                if (responseCode != null) {
                    try {
                        responseLevel = Integer.parseInt(responseCode) / 100;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                switch (responseLevel) {
                    case 3: {
                        httpResponseCode.setForeground(REDIRECT_COLOR);
                    }
                    case 4: {
                        httpResponseCode.setForeground(CLIENT_ERROR_COLOR);
                    }
                    case 5: {
                        httpResponseCode.setForeground(SERVER_ERROR_COLOR);
                    }
                }
                httpResponseCode.setText(JMeterUtils.getResString((String)"HTTP response code") + " : " + responseCode);
                this.gbc.gridx = 0;
                ++this.gbc.gridy;
                this.gridBag.setConstraints(httpResponseCode, this.gbc);
                this.resultPanel.add(httpResponseCode);
                JLabel httpResponseMsg = new JLabel();
                String responseMsgStr = res.getResponseMessage();
                log.debug("valueChanged1 : response message - " + responseMsgStr);
                httpResponseMsg.setText("HTTP response message : " + responseMsgStr);
                this.gbc.gridx = 0;
                ++this.gbc.gridy;
                this.gridBag.setConstraints(httpResponseMsg, this.gbc);
                this.resultPanel.add(httpResponseMsg);
                ++this.gbc.gridy;
                byte[] responseBytes = res.getResponseData();
                ImageIcon icon = null;
                if (res.getDataType() != null && res.getDataType().equals("text")) {
                    try {
                        this.response = new String(responseBytes, "utf-8");
                    }
                    catch (UnsupportedEncodingException err) {
                        this.response = new String(responseBytes);
                    }
                } else if (responseBytes != null) {
                    icon = new ImageIcon(responseBytes);
                }
                if (this.response != null) {
                    this.gbc.gridx = 0;
                    ++this.gbc.gridy;
                    this.gridBag.setConstraints(this.htmlOrTextButton, this.gbc);
                    this.resultPanel.add(this.htmlOrTextButton);
                    if (HTML_BUTTON_LABEL.equals(this.htmlOrTextButton.getText())) {
                        this.showTextResponse(this.response);
                    } else {
                        this.showRenderedResponse(this.response);
                    }
                } else if (icon != null) {
                    JLabel image = new JLabel();
                    image.setIcon(icon);
                    this.gbc.gridx = 0;
                    this.gridBag.setConstraints(image, this.gbc);
                    this.resultPanel.add(image);
                }
                this.resultPanel.repaint();
                this.resultPanel.revalidate();
            }
        }
        log.debug("End : valueChanged1");
    }

    protected void initTextArea() {
        this.textArea = new JTextArea();
        this.textArea.setColumns(70);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setTabSize(4);
        this.gridBag.setConstraints(this.textArea, this.gbc);
        this.resultPanel.add(this.textArea);
        ++this.gbc.gridy;
    }

    protected void showTextResponse(String response) {
        this.resultPanel.remove(this.htmlEditPane);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gridBag.setConstraints(this.textArea, this.gbc);
        this.textArea.setText(response);
        this.textArea.setCaretPosition(0);
        this.resultPanel.add(this.textArea);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.htmlOrTextButton.equals(e.getSource())) {
            if (HTML_BUTTON_LABEL.equals(this.htmlOrTextButton.getText())) {
                this.showRenderedResponse(this.response);
                this.htmlOrTextButton.setText(TEXT_BUTTON_LABEL);
            } else {
                this.showTextResponse(this.response);
                this.htmlOrTextButton.setText(HTML_BUTTON_LABEL);
            }
        }
    }

    protected void initHtmlEditPane() {
        this.htmlEditPane = new JEditorPane();
        HTMLEditorKit htmlKit = new HTMLEditorKit();
        this.htmlEditPane.setEditorKit(htmlKit);
    }

    protected void showRenderedResponse(String response) {
        int htmlIndex = response.indexOf("<HTML>");
        if (htmlIndex < 0) {
            htmlIndex = response.indexOf("<html>");
        }
        if (htmlIndex > -1) {
            this.resultPanel.remove(this.textArea);
            String html = response.substring(htmlIndex, response.length());
            this.htmlEditPane.setText(html);
        } else {
            this.htmlEditPane.setText(response);
        }
        this.htmlEditPane.setCaretPosition(0);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gridBag.setConstraints(this.htmlEditPane, this.gbc);
        this.resultPanel.add(this.htmlEditPane);
    }

    protected void initHtmlOrTextButton() {
        this.htmlOrTextButton = new JButton(HTML_BUTTON_LABEL);
        this.htmlOrTextButton.addActionListener(this);
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        SampleResult rootSampleResult = new SampleResult();
        rootSampleResult.setSampleLabel("Root");
        rootSampleResult.setSuccessful(true);
        this.root = new DefaultMutableTreeNode(rootSampleResult);
        this.treeModel = new DefaultTreeModel(this.root);
        this.jTree = new JTree(this.treeModel);
        this.jTree.setCellRenderer(new ResultsNodeRenderer());
        this.jTree.getSelectionModel().setSelectionMode(1);
        this.jTree.addTreeSelectionListener(this);
        this.treePane = new JScrollPane(this.jTree);
        this.gridBag = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.resultPanel = new JPanel(this.gridBag);
        this.resultPane = new JScrollPane(this.resultPanel);
        this.initHtmlOrTextButton();
        this.initTextArea();
        this.initHtmlEditPane();
        this.treeSplitPane = new JSplitPane(0, this.treePane, this.resultPane);
        this.getFilePanel().add((Component)this.getErrorLoggingCheckbox());
        this.add((Component)this.getFilePanel(), "North");
        this.add(this.treeSplitPane, "Center");
    }

    static {
        HTML_BUTTON_LABEL = HTML_BUTTON_LABEL;
        TEXT_BUTTON_LABEL = TEXT_BUTTON_LABEL;
        log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.gui");
    }

    private class ResultsNodeRenderer
    extends DefaultTreeCellRenderer {
        private ResultsNodeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (!((SampleResult)((DefaultMutableTreeNode)value).getUserObject()).isSuccessful()) {
                this.setForeground(Color.red);
            }
            return this;
        }
    }
}

