/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.visualizers.ImageVisualizer;

public class WindowedVisualizer
extends JPanel
implements ImageVisualizer {
    private Graph graph = new Graph();
    private JTextField windowField;
    private JTextField samplesField;
    private JTextField dataField;
    private JTextField averageField;
    private JTextField deviationField;

    public WindowedVisualizer() {
        JScrollPane graphScrollPanel = new JScrollPane(this.graph);
        graphScrollPanel.setViewportBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JLabel windowLabel = new JLabel("Window");
        this.windowField = new JTextField();
        this.windowField.setEditable(true);
        this.windowField.setColumns(5);
        this.windowField.setText(Integer.toString(this.graph.getWindowSize()));
        JLabel samplesLabel = new JLabel("Samples");
        this.samplesField = new JTextField();
        this.samplesField.setEditable(true);
        this.samplesField.setColumns(5);
        this.samplesField.setText(Integer.toString(this.graph.getSamples()));
        JPanel sidePanel = new JPanel();
        sidePanel.setLayout(new GridLayout(0, 1));
        sidePanel.add(windowLabel);
        sidePanel.add(this.windowField);
        sidePanel.add(samplesLabel);
        sidePanel.add(this.samplesField);
        this.dataField = new JTextField("0000ms");
        this.dataField.setEditable(false);
        this.dataField.setForeground(Color.black);
        this.dataField.setBackground(this.getBackground());
        this.averageField = new JTextField("0000ms");
        this.averageField.setEditable(false);
        this.averageField.setForeground(Color.blue);
        this.averageField.setBackground(this.getBackground());
        JPanel showPanel = new JPanel();
        showPanel.setLayout(new GridLayout(0, 1));
        showPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        showPanel.add(this.dataField);
        showPanel.add(this.averageField);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)sidePanel, "West");
        this.add((Component)graphScrollPanel, "Center");
        this.add((Component)showPanel, "East");
    }

    public synchronized void add(SampleResult sampleResult) {
        long sample = sampleResult.getTime();
        int average = this.graph.add(sample);
        this.dataField.setText(sample + "ms");
        this.averageField.setText(average + "ms");
        this.repaint();
    }

    public synchronized void clear() {
        try {
            this.windowField.setText(Integer.toString(this.graph.setWindowSize(Integer.parseInt(this.windowField.getText()))));
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            this.samplesField.setText(Integer.toString(this.graph.setSamples(Integer.parseInt(this.samplesField.getText()))));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.graph.clear();
        this.dataField.setText("0000ms");
        this.averageField.setText("0000ms");
        this.repaint();
    }

    public String toString() {
        return "Show the samples analysys as windowed dot plots";
    }

    public JPanel getControlPanel() {
        return this;
    }

    public Image getImage() {
        Image result = this.graph.createImage(this.graph.getWidth(), this.graph.getHeight());
        this.graph.paintComponent(result.getGraphics());
        return result;
    }

    public class Graph
    extends JComponent
    implements Scrollable {
        private int counter = 0;
        private int cursor = 0;
        private int sum = 0;
        private int window = 100;
        private int samples = 2000;
        private int max = 1;
        private boolean active = true;
        private int[] sample = new int[this.window];
        private int[] average = new int[this.window];

        public Graph() {
            this.setPreferredSize(this.getPreferredScrollableViewportSize());
        }

        public int getWindowSize() {
            return this.window;
        }

        public int setWindowSize(int window) {
            if (window > 0) {
                this.window = window;
            }
            return this.window;
        }

        public int getSamples() {
            return this.samples;
        }

        public int setSamples(int samples) {
            if (samples > 0) {
                this.samples = samples;
            }
            return this.samples;
        }

        public int add(long sam) {
            if (++this.counter < this.samples) {
                int s = (int)sam;
                this.cursor = this.cursor < this.window - 1 ? ++this.cursor : 0;
                this.sum -= this.sample[this.cursor];
                this.sample[this.cursor] = s;
                this.sum += s;
                if (s > this.max) {
                    this.max = s;
                }
                this.average[this.cursor] = this.sum / this.window;
            } else {
                this.active = false;
            }
            return this.average[this.cursor];
        }

        public void clear() {
            this.sample = new int[this.window];
            this.average = new int[this.window];
            this.sum = 0;
            this.cursor = 0;
            this.counter = 0;
            this.max = 1;
            this.active = true;
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension d = this.getSize();
            int i = 0;
            int x = 0;
            while (i < this.window) {
                int s = this.sample[i] * d.height / this.max;
                g.setColor(Color.black);
                g.fillRect(x, d.height - s - 1, 1, 2);
                int a = this.average[i] * d.height / this.max;
                g.setColor(Color.blue);
                g.fillRect(x, d.height - a - 1, 1, 2);
                ++i;
                ++x;
            }
        }

        public Dimension getPreferredScrollableViewportSize() {
            return new Dimension(400, 200);
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 1;
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 50;
        }

        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        public boolean getScrollableTracksViewportHeight() {
            return true;
        }
    }
}

