/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.ftp.config.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class FtpConfigGui
extends AbstractConfigGui {
    private static final String SERVER = "server";
    private static final String FILENAME = "filename";
    private JTextField server = new JTextField(20);
    private JTextField filename = new JTextField(20);
    private boolean displayName = true;

    public FtpConfigGui() {
        this(true);
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"ftp_sample_title");
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.server.setText((String)element.getProperty("FTPSampler.server"));
        this.filename.setText((String)element.getProperty("FTPSampler.filename"));
    }

    public TestElement createTestElement() {
        ConfigTestElement element = new ConfigTestElement();
        this.configureTestElement((TestElement)element);
        element.setProperty("FTPSampler.server", (Object)this.server.getText());
        element.setProperty("FTPSampler.filename", (Object)this.filename.getText());
        return element;
    }

    public FtpConfigGui(boolean displayName) {
        this.displayName = displayName;
        this.init();
    }

    private JPanel createServerPanel() {
        JPanel serverPanel = new JPanel();
        serverPanel.add(new JLabel(JMeterUtils.getResString((String)SERVER)));
        this.server.setName(SERVER);
        serverPanel.add(this.server);
        return serverPanel;
    }

    private JPanel createFilenamePanel() {
        JPanel filenamePanel = new JPanel();
        filenamePanel.add(new JLabel(JMeterUtils.getResString((String)"file_to_retrieve")));
        this.filename.setName(FILENAME);
        filenamePanel.add(this.filename);
        return filenamePanel;
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(1, 2));
        if (this.displayName) {
            this.setLayout((LayoutManager)new VerticalLayout(5, 2, 1));
            JPanel mainPanel = new JPanel();
            EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
            mainPanel.setBorder(margin);
            mainPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
            JLabel panelTitleLabel = new JLabel(JMeterUtils.getResString((String)"ftp_sample_title"));
            Font curFont = panelTitleLabel.getFont();
            int curFontSize = curFont.getSize();
            panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
            mainPanel.add(panelTitleLabel);
            mainPanel.add((Component)this.getNamePanel());
            mainPanel.add(this.createServerPanel());
            mainPanel.add(this.createFilenamePanel());
            this.add(mainPanel);
        } else {
            this.add(this.createServerPanel());
            this.add(this.createFilenamePanel());
        }
    }

    static {
        SERVER = SERVER;
        FILENAME = FILENAME;
    }
}

