/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.ftp.sampler;

import java.net.ConnectException;
import org.apache.jmeter.config.LoginConfig;
import org.apache.jmeter.protocol.ftp.config.FtpConfig;
import org.apache.jmeter.protocol.ftp.sampler.FtpClient;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;

public class FTPSampler
extends AbstractSampler {
    public static final String SERVER = "FTPSampler.server";
    public static final String FILENAME = "FTPSampler.filename";

    public void addCustomTestElement(TestElement element) {
        if (element instanceof FtpConfig || element instanceof LoginConfig) {
            this.mergeIn(element);
        }
    }

    public String getUsername() {
        return this.getPropertyAsString("ConfigTestElement.username");
    }

    public String getPassword() {
        return this.getPropertyAsString("ConfigTestElement.password");
    }

    public void setServer(String newServer) {
        this.setProperty(SERVER, newServer);
    }

    public String getServer() {
        return (String)this.getProperty(SERVER);
    }

    public void setFilename(String newFilename) {
        this.setProperty(FILENAME, newFilename);
    }

    public String getFilename() {
        return (String)this.getProperty(FILENAME);
    }

    public String getLabel() {
        return "ftp://" + this.getServer() + "/" + this.getFilename();
    }

    public SampleResult sample(Entry e) {
        SampleResult res = new SampleResult();
        Object con = null;
        Object rs = null;
        Object stmt = null;
        boolean isSuccessful = false;
        res.setSampleLabel(this.getLabel());
        long start = System.currentTimeMillis();
        try {
            FtpClient ftp = new FtpClient();
            ftp.connect(this.getServer(), this.getUsername(), this.getPassword());
            ftp.setPassive(true);
            String s = ftp.get(this.getFilename());
            res.setResponseData(s.getBytes());
            ftp.disconnect();
            isSuccessful = true;
        }
        catch (ConnectException cex) {
            res.setResponseData(cex.toString().getBytes());
        }
        catch (Exception ex) {
            res.setResponseData(ex.toString().getBytes());
        }
        long end = System.currentTimeMillis();
        res.setTime(end - start);
        res.setSuccessful(isSuccessful);
        return res;
    }

    static {
        SERVER = SERVER;
        FILENAME = FILENAME;
    }
}

