/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.ftp.sampler;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class FtpClient {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.ftp");
    File f = new File("e:\\");
    BufferedWriter out;
    BufferedReader in;
    Socket s;
    boolean passive = false;
    static int port = 21;
    static int dataPort = 4096;

    public void setPassive(boolean flag) {
        this.passive = flag;
    }

    public String getResponse() throws IOException {
        StringBuffer response = new StringBuffer();
        String line = this.in.readLine();
        response.append(line);
        log.info("FtpClient.getResponse(): #" + line + "#");
        while (line.charAt(3) == '-') {
            line = this.in.readLine();
            response.append("\n");
            response.append(line);
            log.info("FtpClient.getResponse(): #" + line + "#");
        }
        log.info("return response");
        return response.toString();
    }

    public String get(String file) throws Exception {
        this.send("SYST");
        this.getResponse();
        this.send("PWD");
        this.getResponse();
        this.send("TYPE I");
        this.getResponse();
        String data = "";
        if (!this.passive) {
            int upper = FtpClient.getUpper(++dataPort);
            int lower = FtpClient.getLower(dataPort);
            String ip = InetAddress.getLocalHost().getHostAddress().replace('.', ',');
            String port = ip + "," + upper + "," + lower;
            log.info("port:" + port);
            this.send("PORT " + port);
            this.getResponse();
            dataGrabber grab = new dataGrabber(ip, dataPort);
            while (!grab.isPortCreated()) {
            }
            this.send("RETR " + file);
            String response = this.in.readLine();
            log.info(response);
            log.info("" + dataPort);
            data = "FTP client - File Not Found";
            if (!response.startsWith("5")) {
                while (!grab.isDone()) {
                }
                data = grab.getData();
            }
        } else {
            this.send("PASV");
            String port = this.getResponse();
            while (!port.startsWith("227")) {
                port = this.getResponse();
            }
            int start = port.indexOf(40);
            int end = port.indexOf(41);
            port = port.substring(start + 1, end);
            int a = port.indexOf(44);
            int b = port.indexOf(44, a + 1);
            int c = port.indexOf(44, b + 1);
            int d = port.indexOf(44, c + 1);
            int e = port.indexOf(44, d + 1);
            String ip = port.substring(0, a) + "." + port.substring(a + 1, b) + "." + port.substring(b + 1, c) + "." + port.substring(c + 1, d);
            int upper = Integer.parseInt(port.substring(d + 1, e));
            int lower = Integer.parseInt(port.substring(e + 1));
            int dataPort = FtpClient.getPort(upper, lower);
            this.send("RETR " + file);
            dataGrabber grab = new dataGrabber(ip, dataPort);
            this.getResponse();
            while (!grab.isDone()) {
            }
            data = grab.getData();
        }
        return data;
    }

    public void connect(String host, String username, String password) throws Exception {
        InetAddress addr = InetAddress.getByName(host);
        this.s = new Socket(addr, port);
        this.out = new BufferedWriter(new OutputStreamWriter(this.s.getOutputStream()));
        InputStreamReader isr = new InputStreamReader(this.s.getInputStream());
        this.in = new BufferedReader(isr);
        this.send("USER " + username);
        this.send("PASS " + password);
    }

    public void disconnect() {
        try {
            this.send("QUIT");
            this.getResponse();
        }
        catch (Exception e) {
            log.error("FTP client - ", (Throwable)e);
        }
        try {
            this.in.close();
            this.out.close();
            this.s.close();
        }
        catch (Exception e) {
            log.error("FTP client - ", (Throwable)e);
        }
    }

    public void send(String command) throws IOException {
        int i = 0;
        while (i < command.length()) {
            this.out.write(command.charAt(i));
            ++i;
        }
        this.out.write(13);
        this.out.write(10);
        this.out.flush();
    }

    public static int getPort(int upper, int lower) {
        return upper * 256 + lower;
    }

    public static int getUpper(int port) {
        return port / 256;
    }

    public static int getLower(int port) {
        return port % 256;
    }

    public class dataGrabber
    implements Runnable {
        StringBuffer buffer = new StringBuffer();
        Socket s;
        boolean done = false;
        boolean portCreated = false;
        String host = "";
        int port = 22;

        public dataGrabber(String host, int port) throws Exception {
            this.host = host;
            this.port = port;
            new Thread(this).start();
        }

        public boolean isDone() {
            return this.done;
        }

        public String getData() {
            return this.buffer.toString();
        }

        public boolean isPortCreated() {
            return this.portCreated;
        }

        public void run() {
            try {
                if (FtpClient.this.passive) {
                    this.s = new Socket(this.host, this.port);
                } else {
                    log.info("creating socket on " + this.port);
                    ServerSocket server = new ServerSocket(this.port);
                    log.info("accepting...");
                    this.portCreated = true;
                    this.s = server.accept();
                    log.info("accepted");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                InputStream in = this.s.getInputStream();
                BufferedInputStream dataIn = new BufferedInputStream(in);
                int bufferSize = 4096;
                byte[] inputBuffer = new byte[bufferSize];
                int i = 0;
                while ((i = dataIn.read(inputBuffer, 0, bufferSize)) != -1) {
                    this.buffer.append((char)i);
                }
                dataIn.close();
                this.s.close();
            }
            catch (Exception e) {
                log.error("FTP client: dataGrabber", (Throwable)e);
            }
            this.done = true;
        }
    }
}

