/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;

public class IntSum
extends AbstractFunction
implements Serializable {
    private static final List desc = new LinkedList();
    private int sum = 0;
    private static final String KEY = "__intSum";
    private String varName;

    public Object clone() {
        IntSum newIntSum = new IntSum();
        return newIntSum;
    }

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterVariables vars = this.getVariables();
        String totalString = Integer.toString(this.sum);
        vars.put(this.varName, totalString);
        return totalString;
    }

    public void setParameters(String parameters) throws InvalidVariableException {
        Collection params = this.parseArguments(parameters);
        String[] values = params.toArray(new String[0]);
        this.varName = values[values.length - 1];
        this.sum = 0;
        int i = 0;
        while (i < values.length - 1) {
            this.sum += Integer.parseInt(values[i]);
            ++i;
        }
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"intsum_param_1"));
        desc.add(JMeterUtils.getResString((String)"intsum_param_2"));
        desc.add(JMeterUtils.getResString((String)"function_name_param"));
        KEY = KEY;
    }
}

