/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;

public class IterationCounter
extends AbstractFunction
implements Serializable {
    private static int counter;
    private static final List desc;
    private boolean perThread = true;
    private static final String KEY = "__counter";
    private String trueCount;
    private String falseCount;

    public IterationCounter() {
        counter = 0;
    }

    public Object clone() {
        IterationCounter newCounter = new IterationCounter();
        return newCounter;
    }

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterVariables vars = this.getVariables();
        String falseCounterString = Integer.toString(++counter);
        String trueCounterString = Integer.toString(vars.getIteration());
        vars.put(this.trueCount, trueCounterString);
        vars.put(this.falseCount, falseCounterString);
        if (this.perThread) {
            return trueCounterString;
        }
        return falseCounterString;
    }

    public void setParameters(String parameters) throws InvalidVariableException {
        Collection params = this.parseArguments(parameters);
        String[] values = params.toArray(new String[0]);
        this.perThread = new Boolean(values[0]);
        if (values.length > 1) {
            this.trueCount = values[1] + "_true";
            this.falseCount = values[1] + "_false";
        }
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List getArgumentDesc() {
        return desc;
    }

    static {
        desc = new LinkedList();
        desc.add(JMeterUtils.getResString((String)"iteration_counter_arg_1"));
        desc.add(JMeterUtils.getResString((String)"function_name_param"));
        KEY = KEY;
    }
}

