/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Util;

public class RegexFunction
extends AbstractFunction
implements Serializable {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.elements");
    public static final String ALL = "ALL";
    public static final String RAND = "RAND";
    public static final String KEY = "__regexFunction";
    private static Random rand;
    private static List desc;
    Pattern searchPattern;
    Object[] template;
    String valueIndex;
    String defaultValue;
    String between;
    transient PatternCompiler compiler = new Perl5Compiler();
    Pattern templatePattern;
    private String name;
    private static ThreadLocal localMatcher;

    public RegexFunction() {
        try {
            this.templatePattern = this.compiler.compile("\\$(\\d+)\\$");
        }
        catch (MalformedPatternException e) {
            log.error("", (Throwable)e);
        }
    }

    public String execute(SampleResult previousResult, Sampler currentSampler) {
        this.getVariables().put(this.name, this.defaultValue);
        if (previousResult == null || previousResult.getResponseData() == null) {
            return this.defaultValue;
        }
        ArrayList<MatchResult> collectAllMatches = new ArrayList<MatchResult>();
        try {
            PatternMatcher matcher = (PatternMatcher)localMatcher.get();
            String responseText = new String(previousResult.getResponseData());
            PatternMatcherInput input = new PatternMatcherInput(responseText);
            while (matcher.contains(input, this.searchPattern)) {
                MatchResult match = matcher.getMatch();
                collectAllMatches.add(match);
            }
        }
        catch (NumberFormatException e) {
            log.error("", (Throwable)e);
            return this.defaultValue;
        }
        catch (Exception e) {
            return this.defaultValue;
        }
        if (collectAllMatches.size() == 0) {
            return this.defaultValue;
        }
        if (this.valueIndex.equals(ALL)) {
            StringBuffer value = new StringBuffer();
            Iterator it = collectAllMatches.iterator();
            boolean first = true;
            while (it.hasNext()) {
                if (!first) {
                    value.append(this.between);
                } else {
                    first = false;
                }
                value.append(this.generateResult((MatchResult)it.next()));
            }
            return value.toString();
        }
        if (this.valueIndex.equals(RAND)) {
            MatchResult result = (MatchResult)collectAllMatches.get(rand.nextInt(collectAllMatches.size()));
            return this.generateResult(result);
        }
        try {
            int index = Integer.parseInt(this.valueIndex) - 1;
            MatchResult result = (MatchResult)collectAllMatches.get(index);
            return this.generateResult(result);
        }
        catch (NumberFormatException e) {
            float ratio = Float.parseFloat(this.valueIndex);
            MatchResult result = (MatchResult)collectAllMatches.get((int)((double)((float)collectAllMatches.size() * ratio) + 0.5) - 1);
            return this.generateResult(result);
        }
        catch (IndexOutOfBoundsException e) {
            return this.defaultValue;
        }
    }

    private void saveGroups(MatchResult result) {
        if (result != null) {
            JMeterVariables vars = this.getVariables();
            int x = 0;
            while (x < result.groups()) {
                vars.put(this.name + "_g" + x, result.group(x));
                ++x;
            }
        }
    }

    public List getArgumentDesc() {
        return desc;
    }

    private String generateResult(MatchResult match) {
        this.saveGroups(match);
        StringBuffer result = new StringBuffer();
        int a = 0;
        while (a < this.template.length) {
            if (this.template[a] instanceof String) {
                result.append(this.template[a]);
            } else {
                result.append(match.group(((Integer)this.template[a]).intValue()));
            }
            ++a;
        }
        JMeterVariables vars = this.getVariables();
        vars.put(this.name, result.toString());
        return result.toString();
    }

    public String getReferenceKey() {
        return KEY;
    }

    public void setParameters(String params) throws InvalidVariableException {
        try {
            Iterator tk = this.parseArguments(params).iterator();
            this.valueIndex = "1";
            this.between = "";
            this.defaultValue = URLDecoder.decode(params);
            this.searchPattern = this.compiler.compile((String)tk.next());
            this.generateTemplate((String)tk.next());
            if (tk.hasNext()) {
                this.valueIndex = (String)tk.next();
            }
            if (tk.hasNext()) {
                this.between = (String)tk.next();
            }
            if (tk.hasNext()) {
                this.defaultValue = (String)tk.next();
            }
            if (tk.hasNext()) {
                this.name = (String)tk.next();
            }
        }
        catch (MalformedPatternException e) {
            log.error("", (Throwable)e);
            throw new InvalidVariableException("Bad regex pattern");
        }
        catch (Exception e) {
            throw new InvalidVariableException(e.getMessage());
        }
    }

    private void generateTemplate(String rawTemplate) {
        ArrayList pieces = new ArrayList();
        LinkedList<Integer> combined = new LinkedList<Integer>();
        Perl5Matcher matcher = new Perl5Matcher();
        Util.split(pieces, (PatternMatcher)new Perl5Matcher(), (Pattern)this.templatePattern, (String)rawTemplate);
        PatternMatcherInput input = new PatternMatcherInput(rawTemplate);
        boolean count = false;
        Iterator iter = pieces.iterator();
        boolean startsWith = this.isFirstElementGroup(rawTemplate);
        while (iter.hasNext()) {
            boolean matchExists = matcher.contains(input, this.templatePattern);
            if (startsWith) {
                if (matchExists) {
                    combined.add(new Integer(matcher.getMatch().group(1)));
                }
                combined.add((Integer)iter.next());
                continue;
            }
            combined.add((Integer)iter.next());
            if (!matchExists) continue;
            combined.add(new Integer(matcher.getMatch().group(1)));
        }
        if (matcher.contains(input, this.templatePattern)) {
            combined.add(new Integer(matcher.getMatch().group(1)));
        }
        this.template = combined.toArray();
    }

    private boolean isFirstElementGroup(String rawData) {
        try {
            Pattern pattern = this.compiler.compile("^\\$\\d+\\$");
            return new Perl5Matcher().contains(rawData, pattern);
        }
        catch (MalformedPatternException e) {
            log.error("", (Throwable)e);
            return false;
        }
    }

    static {
        ALL = ALL;
        RAND = RAND;
        KEY = KEY;
        rand = new Random();
        desc = new LinkedList();
        localMatcher = new ThreadLocal(){

            protected Object initialValue() {
                return new Perl5Matcher();
            }
        };
        desc.add(JMeterUtils.getResString((String)"regexfunc_param_1"));
        desc.add(JMeterUtils.getResString((String)"regexfunc_param_2"));
        desc.add(JMeterUtils.getResString((String)"regexfunc_param_3"));
        desc.add(JMeterUtils.getResString((String)"regexfunc_param_4"));
        desc.add(JMeterUtils.getResString((String)"regexfunc_param_5"));
        desc.add(JMeterUtils.getResString((String)"function_name_param"));
    }

    public static class Test
    extends TestCase {
        RegexFunction variable;
        SampleResult result;

        public Test(String name) {
            super(name);
        }

        public void setUp() {
            this.variable = new RegexFunction();
            this.result = new SampleResult();
            String data = "<company-xmlext-query-ret><row><value field=\"RetCode\">LIS_OK</value><value field=\"RetCodeExtension\"></value><value field=\"alias\"></value><value field=\"positioncount\"></value><value field=\"invalidpincount\">0</value><value field=\"pinposition1\">1</value><value field=\"pinpositionvalue1\"></value><value field=\"pinposition2\">5</value><value field=\"pinpositionvalue2\"></value><value field=\"pinposition3\">6</value><value field=\"pinpositionvalue3\"></value></row></company-xmlext-query-ret>";
            this.result.setResponseData(data.getBytes());
        }

        public void testVariableExtraction() throws Exception {
            this.variable.setParameters(URLEncoder.encode("<value field=\"(pinposition\\d+)\">(\\d+)</value>") + ",$2$,2");
            this.variable.setJMeterVariables(new JMeterVariables());
            String match = this.variable.execute(this.result, null);
            Assert.assertEquals((Object)"5", (Object)match);
        }

        public void testVariableExtraction2() throws Exception {
            this.variable.setParameters(URLEncoder.encode("<value field=\"(pinposition\\d+)\">(\\d+)</value>") + ",$1$,3");
            this.variable.setJMeterVariables(new JMeterVariables());
            String match = this.variable.execute(this.result, null);
            Assert.assertEquals((Object)"pinposition3", (Object)match);
        }

        public void testVariableExtraction5() throws Exception {
            this.variable.setParameters(URLEncoder.encode("<value field=\"(pinposition\\d+)\">(\\d+)</value>") + ",$1$,ALL,_");
            this.variable.setJMeterVariables(new JMeterVariables());
            String match = this.variable.execute(this.result, null);
            Assert.assertEquals((Object)"pinposition1_pinposition2_pinposition3", (Object)match);
        }

        public void testVariableExtraction6() throws Exception {
            this.variable.setParameters(URLEncoder.encode("<value field=\"(pinposition\\d+)\">(\\d+)</value>") + ",$2$,4,,default");
            this.variable.setJMeterVariables(new JMeterVariables());
            String match = this.variable.execute(this.result, null);
            Assert.assertEquals((Object)"default", (Object)match);
        }

        public void testComma() throws Exception {
            this.variable.setParameters(URLEncoder.encode("<value,? field=\"(pinposition\\d+)\">(\\d+)</value>") + ",$1$,3");
            this.variable.setJMeterVariables(new JMeterVariables());
            String match = this.variable.execute(this.result, null);
            Assert.assertEquals((Object)"pinposition3", (Object)match);
        }

        public void testVariableExtraction3() throws Exception {
            this.variable.setParameters(URLEncoder.encode("<value field=\"(pinposition\\d+)\">(\\d+)</value>") + ",_$1$,.5");
            this.variable.setJMeterVariables(new JMeterVariables());
            String match = this.variable.execute(this.result, null);
            Assert.assertEquals((Object)"_pinposition2", (Object)match);
        }

        public void testVariableExtraction4() throws Exception {
            this.variable.setParameters(URLEncoder.encode("<value field=\"(pinposition\\d+)\">(\\d+)</value>") + "," + URLEncoder.encode("$2$, ") + ",.333");
            this.variable.setJMeterVariables(new JMeterVariables());
            String match = this.variable.execute(this.result, null);
            Assert.assertEquals((Object)"1, ", (Object)match);
        }

        public void testDefaultValue() throws Exception {
            this.variable.setParameters(URLEncoder.encode("<value,, field=\"(pinposition\\d+)\">(\\d+)</value>") + "," + URLEncoder.encode("$2$, ") + ",.333,,No Value Found");
            this.variable.setJMeterVariables(new JMeterVariables());
            String match = this.variable.execute(this.result, null);
            Assert.assertEquals((Object)"No Value Found", (Object)match);
        }
    }
}

