/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jdbc.config.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.config.gui.LoginConfigGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class DbConfigGui
extends AbstractConfigGui {
    private static final String LOGIN_ELEMENT = "DbConfigGui.login_element";
    private static String PROTOCOL;
    private static String URL;
    private static String DRIVER;
    private JTextField urlField = new JTextField(20);
    private JTextField driverField = new JTextField(20);
    private boolean displayName;
    private LoginConfigGui loginGui;

    public DbConfigGui() {
        this(true);
    }

    public DbConfigGui(boolean displayName) {
        this.displayName = displayName;
        this.init();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"database_login_title");
    }

    public TestElement createTestElement() {
        ConfigTestElement element = new ConfigTestElement();
        this.configureTestElement((TestElement)element);
        element.setProperty("JDBCSampler.url", (Object)this.urlField.getText());
        element.setProperty("JDBCSampler.driver", (Object)this.driverField.getText());
        element.addTestElement(this.loginGui.createTestElement());
        return element;
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.urlField.setText((String)element.getProperty("JDBCSampler.url"));
        this.driverField.setText((String)element.getProperty("JDBCSampler.driver"));
        this.loginGui.configure(element);
    }

    private void init() {
        if (this.displayName) {
            this.setLayout((LayoutManager)new VerticalLayout(5, 2, 1));
            JPanel mainPanel = new JPanel();
            EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
            mainPanel.setBorder(margin);
            mainPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
            JLabel panelTitleLabel = new JLabel(JMeterUtils.getResString((String)"database_login_title"));
            Font curFont = panelTitleLabel.getFont();
            int curFontSize = curFont.getSize();
            panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
            mainPanel.add(panelTitleLabel);
            mainPanel.add((Component)this.getNamePanel());
            JPanel urlJDBCPanel = new JPanel();
            urlJDBCPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
            urlJDBCPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"database_url_jdbc_props")));
            urlJDBCPanel.add(this.getUrlPanel());
            urlJDBCPanel.add(this.getDriverPanel());
            mainPanel.add(urlJDBCPanel);
            this.loginGui = new LoginConfigGui(false);
            JPanel loginPanel = new JPanel();
            loginPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"login_config")));
            loginPanel.add((Component)this.loginGui);
            mainPanel.add(loginPanel);
            this.add(mainPanel);
        } else {
            this.setLayout((LayoutManager)new VerticalLayout(5, 2));
            JPanel urlJDBCPanel = new JPanel();
            urlJDBCPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
            urlJDBCPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"database_url_jdbc_props")));
            urlJDBCPanel.add(this.getUrlPanel());
            urlJDBCPanel.add(this.getDriverPanel());
            this.add(urlJDBCPanel);
            this.loginGui = new LoginConfigGui(false);
            JPanel loginPanel = new JPanel();
            loginPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"login_config")));
            loginPanel.add((Component)this.loginGui);
            this.add(loginPanel);
        }
    }

    private JPanel getDriverPanel() {
        JPanel panel = new JPanel();
        panel.add(new JLabel(JMeterUtils.getResString((String)"database_driver_class")));
        this.driverField.setName(DRIVER);
        panel.add(this.driverField);
        return panel;
    }

    private JPanel getUrlPanel() {
        JPanel panel = new JPanel();
        panel.add(new JLabel(JMeterUtils.getResString((String)"database_url")));
        this.urlField.setName(URL);
        panel.add(this.urlField);
        return panel;
    }

    static {
        LOGIN_ELEMENT = LOGIN_ELEMENT;
        PROTOCOL = "protocol";
        URL = "url";
        DRIVER = "driver";
    }
}

