/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jdbc.config.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.protocol.jdbc.sampler.JDBCSampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class PoolConfigGui
extends AbstractConfigGui
implements FocusListener {
    private static String CONNECTIONS = "connections";
    private static String MAXUSE = "maxuse";
    private static String DEFAULT_MAX_USE = "50";
    private static String DEFAULT_NUM_CONNECTIONS = "1";
    private JTextField connField = new JTextField(5);
    private JTextField maxUseField = new JTextField(5);
    private boolean displayName;

    public PoolConfigGui() {
        this(true);
    }

    public PoolConfigGui(boolean displayName) {
        this.displayName = displayName;
        this.init();
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.connField.setText(element.getProperty(JDBCSampler.CONNECTIONS).toString());
        this.maxUseField.setText(element.getProperty(JDBCSampler.MAXUSE).toString());
    }

    public TestElement createTestElement() {
        ConfigTestElement element = new ConfigTestElement();
        this.configureTestElement((TestElement)element);
        element.setProperty(JDBCSampler.CONNECTIONS, (Object)this.connField.getText());
        element.setProperty(JDBCSampler.MAXUSE, (Object)this.maxUseField.getText());
        return element;
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"database_conn_pool_title");
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        String name = e.getComponent().getName();
        if (name.equals(CONNECTIONS)) {
            try {
                Integer.parseInt(this.connField.getText());
            }
            catch (NumberFormatException nfe) {
                if (this.connField.getText().length() > 0) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "You must enter a valid number", "Invalid data", 2);
                }
                this.connField.setText(DEFAULT_NUM_CONNECTIONS);
            }
        } else if (name.equals(MAXUSE)) {
            try {
                Integer.parseInt(this.maxUseField.getText());
            }
            catch (NumberFormatException nfe) {
                if (this.maxUseField.getText().length() > 0) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "You must enter a valid number", "Invalid data", 2);
                }
                this.maxUseField.setText(DEFAULT_NUM_CONNECTIONS);
            }
        }
    }

    private void init() {
        if (this.displayName) {
            this.setLayout((LayoutManager)new VerticalLayout(5, 2, 1));
            JPanel mainPanel = new JPanel();
            EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
            mainPanel.setBorder(margin);
            mainPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
            JLabel panelTitleLabel = new JLabel(JMeterUtils.getResString((String)"database_conn_pool_title"));
            Font curFont = panelTitleLabel.getFont();
            int curFontSize = curFont.getSize();
            panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
            mainPanel.add(panelTitleLabel);
            mainPanel.add((Component)this.getNamePanel());
            JPanel connPoolPanel = new JPanel();
            connPoolPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
            connPoolPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"database_conn_pool_props")));
            connPoolPanel.add(this.createConnPanel());
            connPoolPanel.add(this.createMaxUsePanel());
            mainPanel.add(connPoolPanel);
            this.add(mainPanel);
        } else {
            this.setLayout((LayoutManager)new VerticalLayout(5, 2));
            JPanel connPoolPanel = new JPanel();
            connPoolPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
            connPoolPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"database_conn_pool_props")));
            connPoolPanel.add(this.createConnPanel());
            connPoolPanel.add(this.createMaxUsePanel());
            this.add(connPoolPanel);
        }
    }

    private JPanel createConnPanel() {
        JPanel panel = new JPanel();
        panel.add(new JLabel(JMeterUtils.getResString((String)"database_conn_pool_size")));
        this.connField.setText(DEFAULT_NUM_CONNECTIONS);
        this.connField.setName(CONNECTIONS);
        this.connField.addFocusListener(this);
        panel.add(this.connField);
        return panel;
    }

    private JPanel createMaxUsePanel() {
        JPanel panel = new JPanel();
        panel.add(new JLabel(JMeterUtils.getResString((String)"database_conn_pool_max_usage")));
        this.maxUseField.setText(DEFAULT_MAX_USE);
        this.maxUseField.setName(MAXUSE);
        this.maxUseField.addFocusListener(this);
        panel.add(this.maxUseField);
        return panel;
    }
}

