/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jdbc.config.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class SqlConfigGui
extends AbstractConfigGui {
    private JTextField sqlField = new JTextField(30);
    private boolean displayName;

    public SqlConfigGui() {
        this(true);
    }

    public SqlConfigGui(boolean displayName) {
        this.displayName = displayName;
        this.init();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"database_sql_query_title");
    }

    public void configure(TestElement element) {
        this.sqlField.setText(element.getProperty("JDBCSampler.query").toString());
        super.configure(element);
    }

    public TestElement createTestElement() {
        ConfigTestElement element = new ConfigTestElement();
        this.configureTestElement((TestElement)element);
        element.setProperty("JDBCSampler.query", (Object)this.sqlField.getText());
        return element;
    }

    private void init() {
        if (this.displayName) {
            this.setLayout((LayoutManager)new VerticalLayout(5, 2, 1));
            JPanel mainPanel = new JPanel();
            EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
            mainPanel.setBorder(margin);
            mainPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
            JLabel panelTitleLabel = new JLabel(JMeterUtils.getResString((String)"database_sql_query_title"));
            Font curFont = panelTitleLabel.getFont();
            int curFontSize = curFont.getSize();
            panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
            mainPanel.add(panelTitleLabel);
            mainPanel.add((Component)this.getNamePanel());
            mainPanel.add(this.createSqlPanel());
            this.add(mainPanel);
        } else {
            this.setLayout((LayoutManager)new VerticalLayout(5, 2));
            this.add(this.createSqlPanel());
        }
    }

    private JPanel createSqlPanel() {
        JPanel panel = new JPanel();
        panel.add(new JLabel(JMeterUtils.getResString((String)"database_sql_query_string")));
        panel.add(this.sqlField);
        return panel;
    }
}

