/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jdbc.control.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.protocol.jdbc.config.gui.DbConfigGui;
import org.apache.jmeter.protocol.jdbc.config.gui.PoolConfigGui;
import org.apache.jmeter.protocol.jdbc.config.gui.SqlConfigGui;
import org.apache.jmeter.protocol.jdbc.sampler.JDBCSampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class JdbcTestSampleGui
extends AbstractSamplerGui {
    PoolConfigGui poolGui;
    DbConfigGui dbGui;
    SqlConfigGui sqlGui;

    public JdbcTestSampleGui() {
        this.init();
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.dbGui.configure(element);
        this.poolGui.configure(element);
        this.sqlGui.configure(element);
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"database_testing_title");
    }

    public TestElement createTestElement() {
        JDBCSampler sampler = new JDBCSampler();
        sampler.addTestElement(this.dbGui.createTestElement());
        sampler.addTestElement(this.poolGui.createTestElement());
        sampler.addTestElement(this.sqlGui.createTestElement());
        this.configureTestElement((TestElement)sampler);
        return sampler;
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 2, 1));
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
        JLabel panelTitleLabel = new JLabel(JMeterUtils.getResString((String)"database_testing_title"));
        Font curFont = panelTitleLabel.getFont();
        int curFontSize = curFont.getSize();
        panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
        mainPanel.add(panelTitleLabel);
        mainPanel.add((Component)this.getNamePanel());
        this.dbGui = new DbConfigGui(false);
        mainPanel.add((Component)((Object)this.dbGui));
        this.poolGui = new PoolConfigGui(false);
        mainPanel.add((Component)((Object)this.poolGui));
        this.sqlGui = new SqlConfigGui(false);
        mainPanel.add((Component)((Object)this.sqlGui));
        this.add(mainPanel);
    }
}

