/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jdbc.sampler;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.protocol.jdbc.config.DbConfig;
import org.apache.jmeter.protocol.jdbc.config.PoolConfig;
import org.apache.jmeter.protocol.jdbc.config.SqlConfig;
import org.apache.jmeter.protocol.jdbc.util.DBConnectionManager;
import org.apache.jmeter.protocol.jdbc.util.DBKey;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jorphan.collections.Data;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class JDBCSampler
extends AbstractSampler
implements TestListener {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.jdbc");
    public static final String URL = "JDBCSampler.url";
    public static final String DRIVER = "JDBCSampler.driver";
    public static String CONNECTIONS;
    public static String MAXUSE;
    transient DBConnectionManager manager = DBConnectionManager.getManager();
    public static final String QUERY = "JDBCSampler.query";
    private static Map keyMap;
    private static boolean running;

    public void addCustomTestElement(TestElement element) {
        if (element instanceof SqlConfig || element instanceof PoolConfig || element instanceof DbConfig) {
            this.mergeIn(element);
        }
    }

    public void testStarted(String host) {
    }

    public void testEnded(String host) {
    }

    public synchronized void testStarted() {
        if (!running) {
            running = true;
        }
    }

    public synchronized void testEnded() {
        if (running) {
            this.manager.shutdown();
            keyMap.clear();
            running = false;
        }
    }

    public String getQuery() {
        return this.getPropertyAsString(QUERY);
    }

    public SampleResult sample(Entry e) {
        DBKey key = this.getKey();
        long end = 0L;
        long start = 0L;
        long time = 0L;
        SampleResult res = new SampleResult();
        Connection con = null;
        ResultSet rs = null;
        Statement stmt = null;
        Data data = new Data();
        res.setSampleLabel(this.getQuery());
        start = System.currentTimeMillis();
        try {
            int count = 0;
            while (count < 20 && (con = this.manager.getConnection(key)) == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception err) {
                    ++count;
                }
            }
            stmt = con.createStatement();
            boolean retVal = stmt.execute(this.getQuery());
            if (retVal) {
                rs = stmt.getResultSet();
                data = this.getDataFromResultSet(rs);
                rs.close();
            } else {
                int updateCount = stmt.getUpdateCount();
            }
            stmt.close();
            this.manager.releaseConnection(con);
            res.setResponseData(data.toString().getBytes());
            res.setDataType("text");
            res.setSuccessful(true);
        }
        catch (Exception ex) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException err) {
                    rs = null;
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException err) {
                    stmt = null;
                }
            }
            this.manager.releaseConnection(con);
            log.error("Error in JDBC sampling", (Throwable)ex);
            res.setResponseData(new byte[0]);
            res.setSuccessful(false);
        }
        end = System.currentTimeMillis();
        res.setTime(time += end - start);
        res.setSamplerData((TestElement)this);
        return res;
    }

    public String getUrl() {
        return this.getPropertyAsString(URL);
    }

    public String getUsername() {
        return this.getPropertyAsString("ConfigTestElement.username");
    }

    public String getPassword() {
        return this.getPropertyAsString("ConfigTestElement.password");
    }

    public String getDriver() {
        return this.getPropertyAsString(DRIVER);
    }

    public int getMaxUse() {
        return this.getPropertyAsInt(MAXUSE);
    }

    public int getNumConnections() {
        return this.getPropertyAsInt(CONNECTIONS);
    }

    private DBKey getKey() {
        DBKey key = (DBKey)keyMap.get(this.getUrl());
        if (key == null) {
            key = this.manager.getKey(this.getUrl(), this.getUsername(), this.getPassword(), this.getDriver(), this.getMaxUse(), this.getNumConnections());
            keyMap.put(this.getUrl(), key);
        }
        return key;
    }

    private Data getDataFromResultSet(ResultSet rs) throws SQLException {
        Data data = new Data();
        ResultSetMetaData meta = rs.getMetaData();
        int numColumns = meta.getColumnCount();
        String[] dbCols = new String[numColumns];
        int count = 1;
        while (count <= numColumns) {
            dbCols[count - 1] = meta.getColumnName(count);
            data.addHeader(dbCols[count - 1]);
            ++count;
        }
        while (rs.next()) {
            data.next();
            int count2 = 0;
            while (count2 < numColumns) {
                Object o = rs.getObject(count2 + 1);
                if (o != null && o instanceof byte[]) {
                    o = new String((byte[])o);
                }
                data.addColumnValue(dbCols[count2], o);
                ++count2;
            }
        }
        return data;
    }

    public String toString() {
        return this.getUrl() + ", user: " + this.getUsername() + "\n" + this.getQuery();
    }

    static {
        URL = URL;
        DRIVER = DRIVER;
        CONNECTIONS = "JDBCSampler.connections";
        MAXUSE = "JDBCSampler.maxuse";
        QUERY = QUERY;
        keyMap = new HashMap();
        running = false;
    }
}

