/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jdbc.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.jmeter.protocol.jdbc.util.ConnectionObject;
import org.apache.jmeter.protocol.jdbc.util.DBKey;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class DBConnectionManager {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.jdbc");
    int absoluteMaxConnections = 100;
    long accessInterval = 1800000L;
    Hashtable connections;
    Hashtable rentedConnections;
    static DBConnectionManager manager;

    private DBConnectionManager() {
        if (this.connections == null) {
            this.connections = new Hashtable();
        }
        if (this.rentedConnections == null) {
            this.rentedConnections = new Hashtable();
        }
    }

    public static DBConnectionManager getManager() {
        if (manager == null) {
            manager = new DBConnectionManager();
        }
        return manager;
    }

    public DBKey getKey(String url, String username, String password, String driver, int maxUsage, int maxConnections) {
        DBKey key = new DBKey();
        if (this.registerDriver(driver)) {
            key.setDriver(driver);
            key.setMaxConnections(maxConnections);
            key.setMaxUsage(maxUsage);
            key.setPassword(password);
            key.setUrl(url);
            key.setUsername(username);
            if (!this.connections.containsKey(key)) {
                this.setup(key);
            }
        } else {
            key = null;
        }
        return key;
    }

    public void setup(DBKey key) {
        String url = key.getUrl();
        String username = key.getUsername();
        String password = key.getPassword();
        int maxConnections = key.getMaxConnections();
        int maxUsage = key.getMaxUsage();
        try {
            DriverManager.registerDriver((Driver)Class.forName(key.getDriver()).newInstance());
            DatabaseMetaData md = DriverManager.getConnection(url, username, password).getMetaData();
            int dbMax = md.getMaxConnections();
            if (dbMax > 0 && maxConnections > dbMax) {
                maxConnections = dbMax;
                key.setMaxConnections(maxConnections);
            } else if (maxConnections > this.absoluteMaxConnections) {
                maxConnections = this.absoluteMaxConnections;
                key.setMaxConnections(maxConnections);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            maxConnections = 1;
        }
        ConnectionObject[] connectionArray = new ConnectionObject[maxConnections];
        int count = -1;
        while (++count < maxConnections) {
            connectionArray[count] = new ConnectionObject(this, key);
        }
        this.connections.put(key, connectionArray);
        System.gc();
    }

    public void shutdown() {
        Iterator iter = this.connections.keySet().iterator();
        while (iter.hasNext()) {
            this.close((DBKey)iter.next());
        }
    }

    public Connection getConnection(DBKey key) {
        ConnectionObject[] connectionArray = (ConnectionObject[])this.connections.get(key);
        int maxConnections = key.getMaxConnections();
        Connection c = null;
        int index = (int)(100.0 * Math.random());
        int count = -1;
        while (++count < maxConnections && c == null) {
            c = connectionArray[++index % maxConnections].grab();
        }
        if (c != null) {
            this.rentedConnections.put(c, connectionArray[index % maxConnections]);
        }
        return c;
    }

    public void releaseConnection(Connection c) {
        if (c == null) {
            return;
        }
        ConnectionObject connOb = (ConnectionObject)this.rentedConnections.get(c);
        if (connOb != null) {
            this.rentedConnections.remove(c);
            connOb.release();
        } else {
            log.warn("DBConnectionManager: Lost a connection connection='" + c);
            c = null;
        }
    }

    public Connection newConnection(DBKey key) throws SQLException {
        Connection c = DriverManager.getConnection(key.getUrl(), key.getUsername(), key.getPassword());
        return c;
    }

    public void close(DBKey key) {
        ConnectionObject[] connectionArray = (ConnectionObject[])this.connections.get(key);
        int count = -1;
        while (++count < connectionArray.length) {
            connectionArray[count].close();
            connectionArray[count] = null;
        }
        this.connections.remove(key);
    }

    public boolean registerDriver(String driver) {
        try {
            DriverManager.registerDriver((Driver)Class.forName(driver).newInstance());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return false;
        }
        return true;
    }
}

