/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.junit.protocol.http.config;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.testelement.TestElement;

public class UrlConfigTest
extends TestCase {
    HTTPSampler config;
    HTTPSampler defaultConfig;
    HTTPSampler partialConfig;

    public UrlConfigTest(String name) {
        super(name);
    }

    protected void setUp() {
        Arguments args = new Arguments();
        args.addArgument("username", (Object)"mstover");
        args.addArgument("password", (Object)"pass");
        args.addArgument("action", (Object)"login");
        this.config = new HTTPSampler();
        this.config.setName("Full Config");
        this.config.setProperty("HTTPSampler.domain", "www.lazer.com");
        this.config.setProperty("HTTPSampler.path", "login.jsp");
        this.config.setProperty("HTTPSampler.method", "POST");
        this.config.setProperty("HTTPsampler.Arguments", args);
        this.defaultConfig = new HTTPSampler();
        this.defaultConfig.setName("default");
        this.defaultConfig.setProperty("HTTPSampler.domain", "www.xerox.com");
        this.defaultConfig.setProperty("HTTPSampler.path", "default.html");
        this.partialConfig = new HTTPSampler();
        this.partialConfig.setProperty("HTTPSampler.path", "main.jsp");
        this.partialConfig.setProperty("HTTPSampler.method", "GET");
    }

    public void testSimpleConfig() {
        Assert.assertTrue((boolean)this.config.getName().equals("Full Config"));
        Assert.assertEquals((Object)this.config.getDomain(), (Object)"www.lazer.com");
    }

    public void testOverRide() {
        UrlConfigTest.assertNull((Object)this.partialConfig.getProperty("HTTPSampler.domain"));
        this.partialConfig.addTestElement((TestElement)this.defaultConfig);
        Assert.assertEquals((Object)this.partialConfig.getProperty("HTTPSampler.domain"), (Object)"www.xerox.com");
        Assert.assertEquals((Object)this.partialConfig.getProperty("HTTPSampler.path"), (Object)"main.jsp");
    }

    public static void main(String[] args) {
    }
}

