/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.protocol.http.gui.HTTPArgumentsPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextField;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class HttpDefaultsGui
extends AbstractConfigGui {
    JLabeledTextField protocol;
    JLabeledTextField domain;
    JLabeledTextField path;
    JLabeledTextField port;
    HTTPArgumentsPanel argPanel;

    public HttpDefaultsGui() {
        this.init();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"url_config_title");
    }

    public TestElement createTestElement() {
        ConfigTestElement config = new ConfigTestElement();
        super.configureTestElement((TestElement)config);
        config.setProperty("HTTPSampler.protocol", (Object)this.protocol.getText());
        config.setProperty("HTTPSampler.domain", (Object)this.domain.getText());
        config.setProperty("HTTPSampler.path", (Object)this.path.getText());
        config.setProperty("HTTPsampler.Arguments", (Object)this.argPanel.createTestElement());
        config.setProperty("HTTPSampler.port", (Object)this.port.getText());
        return config;
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.protocol.setText(el.getPropertyAsString("HTTPSampler.protocol"));
        this.domain.setText(el.getPropertyAsString("HTTPSampler.domain"));
        this.path.setText(el.getPropertyAsString("HTTPSampler.path"));
        this.port.setText(el.getPropertyAsString("HTTPSampler.port"));
        this.argPanel.configure((TestElement)el.getProperty("HTTPsampler.Arguments"));
    }

    private void init() {
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        this.setBorder(margin);
        this.setLayout(new BorderLayout());
        this.argPanel = new HTTPArgumentsPanel();
        this.add((Component)((Object)this.argPanel), "Center");
        this.protocol = new JLabeledTextField(JMeterUtils.getResString((String)"url_config_protocol"));
        this.domain = new JLabeledTextField(JMeterUtils.getResString((String)"web_server_domain"));
        this.path = new JLabeledTextField(JMeterUtils.getResString((String)"path"));
        this.port = new JLabeledTextField(JMeterUtils.getResString((String)"web_server_port"));
        JPanel topPanel = new JPanel((LayoutManager)new VerticalLayout(5, 2));
        JLabel title = new JLabel(JMeterUtils.getResString((String)"url_config_title"));
        Font curFont = title.getFont();
        int curFontSize = curFont.getSize();
        title.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
        topPanel.add(title);
        topPanel.add((Component)this.getNamePanel());
        topPanel.add((Component)this.protocol);
        topPanel.add((Component)this.domain);
        topPanel.add((Component)this.path);
        topPanel.add((Component)this.port);
        this.add(topPanel, "North");
    }
}

