/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.protocol.http.config.gui.UrlConfigGui;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class MultipartUrlConfigGui
extends UrlConfigGui
implements ActionListener {
    JTextField filenameField;
    JTextField paramNameField;
    JTextField mimetypeField;
    JLabel filenameLabel;
    JLabel paramNameLabel;
    JLabel mimetypeLabel;
    JButton browseFileButton;
    private static String FILENAME = "filename";
    private static String BROWSE = "browse";
    private static String PARAMNAME = "paramname";
    private static String MIMETYPE = "mimetype";

    public TestElement createTestElement() {
        TestElement ce = super.createTestElement();
        this.configureTestElement(ce);
        ce.setProperty("HTTPSampler.mimetype", (Object)this.mimetypeField.getText());
        ce.setProperty("HTTPSampler.FILE_NAME", (Object)this.filenameField.getText());
        ce.setProperty("HTTPSampler.FILE_FIELD", (Object)this.paramNameField.getText());
        return ce;
    }

    public void configureSampler(HTTPSampler sampler) {
        sampler.setMimetype(this.mimetypeField.getText());
        sampler.setFileField(this.paramNameField.getText());
        sampler.setFilename(this.filenameField.getText());
        super.configureSampler(sampler);
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.mimetypeField.setText((String)el.getProperty("HTTPSampler.mimetype"));
        this.filenameField.setText((String)el.getProperty("HTTPSampler.FILE_NAME"));
        this.paramNameField.setText((String)el.getProperty("HTTPSampler.FILE_FIELD"));
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"url_multipart_config_title");
    }

    public void updateGui() {
    }

    public void actionPerformed(ActionEvent e) {
        String name = e.getActionCommand();
        if (name.equals(BROWSE)) {
            JFileChooser chooser = FileDialoger.promptToOpenFile();
            if (chooser == null) {
                return;
            }
            File file = chooser.getSelectedFile();
            if (file != null) {
                this.filenameField.setText(file.getPath());
            }
        }
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        JPanel webServerPanel = new JPanel();
        webServerPanel.setLayout(new BorderLayout());
        webServerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"web_server")));
        webServerPanel.add((Component)this.getDomainPanel(), "North");
        webServerPanel.add((Component)this.getPortPanel(), "South");
        JPanel webRequestPanel = new JPanel(new BorderLayout());
        JPanel northPanel = new JPanel(new BorderLayout());
        webRequestPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"web_request")));
        northPanel.add((Component)this.getProtocolAndMethodPanel(), "North");
        northPanel.add((Component)this.getPathPanel(), "South");
        webRequestPanel.add((Component)northPanel, "North");
        webRequestPanel.add((Component)this.getParameterPanel(), "Center");
        webRequestPanel.add((Component)this.getFilePanel(), "South");
        this.add((Component)webServerPanel, "North");
        this.add((Component)webRequestPanel, "Center");
    }

    protected JPanel getFilePanel() {
        JPanel filePanel = new JPanel();
        filePanel.setLayout((LayoutManager)new VerticalLayout(1, 2));
        filePanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        JLabel sendFileLabel = new JLabel(JMeterUtils.getResString((String)"send_file"));
        filePanel.add(sendFileLabel);
        JPanel filenamePanel = new JPanel();
        filenamePanel.setBorder(BorderFactory.createEmptyBorder(0, 25, 0, 0));
        this.filenameLabel = new JLabel(JMeterUtils.getResString((String)"send_file_filename_label"));
        this.filenameLabel.setEnabled(true);
        this.filenameField = new JTextField(15);
        this.filenameField.setEnabled(true);
        this.filenameField.setName(FILENAME);
        this.browseFileButton = new JButton(JMeterUtils.getResString((String)"send_file_browse"));
        this.browseFileButton.setEnabled(true);
        this.browseFileButton.setActionCommand(BROWSE);
        this.browseFileButton.addActionListener(this);
        filenamePanel.add(this.filenameLabel);
        filenamePanel.add(this.filenameField);
        filenamePanel.add(this.browseFileButton);
        JPanel paramNamePanel = new JPanel();
        paramNamePanel.setBorder(BorderFactory.createEmptyBorder(0, 25, 0, 0));
        this.paramNameLabel = new JLabel(JMeterUtils.getResString((String)"send_file_param_name_label"));
        this.paramNameLabel.setEnabled(true);
        this.paramNameField = new JTextField(15);
        this.paramNameField.setName(PARAMNAME);
        this.paramNameField.setEnabled(true);
        paramNamePanel.add(this.paramNameLabel);
        paramNamePanel.add(this.paramNameField);
        JPanel mimePanel = new JPanel();
        mimePanel.setBorder(BorderFactory.createEmptyBorder(0, 25, 0, 0));
        this.mimetypeLabel = new JLabel(JMeterUtils.getResString((String)"send_file_mime_label"));
        this.mimetypeLabel.setEnabled(true);
        this.mimetypeField = new JTextField(15);
        this.mimetypeField.setEnabled(true);
        this.mimetypeField.setName(MIMETYPE);
        mimePanel.add(this.mimetypeLabel);
        mimePanel.add(this.mimetypeField);
        filePanel.add(filenamePanel);
        filePanel.add(paramNamePanel);
        filePanel.add(mimePanel);
        return filePanel;
    }
}

