/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.protocol.http.gui.HTTPArgumentsPanel;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class UrlConfigGui
extends JPanel {
    protected HTTPArgumentsPanel argsPanel;
    private static String DOMAIN = "domain";
    private static String PORT = "port";
    private static String PROTOCOL = "protocol";
    private static String PATH = "path";
    private static String FOLLOW_REDIRECTS = "follow_redirects";
    private static String USE_KEEPALIVE = "use_keepalive";
    private static String POST = "post";
    private static String GET = "get";
    private static String SEND_PARAM = "sendparam";
    private JTextField domain;
    private JTextField port;
    private JTextField protocol;
    private JTextField path;
    private JCheckBox followRedirects;
    private JCheckBox useKeepAlive;
    private JRadioButton post;
    private JRadioButton get;

    public UrlConfigGui() {
        this.init();
    }

    protected void configureTestElement(TestElement mc) {
        mc.setProperty("TestElement.name", (Object)this.getName());
        mc.setProperty("TestElement.gui_class", (Object)this.getClass().getName());
        mc.setProperty("TestElement.test_class", (Object)mc.getClass().getName());
    }

    public TestElement createTestElement() {
        ConfigTestElement element = new ConfigTestElement();
        this.configureTestElement((TestElement)element);
        Arguments args = (Arguments)this.argsPanel.createTestElement();
        HTTPArgument.convertArgumentsToHTTP(args);
        element.setProperty("HTTPsampler.Arguments", (Object)args);
        element.setProperty("HTTPSampler.domain", (Object)this.domain.getText());
        element.setProperty("HTTPSampler.port", (Object)this.port.getText());
        element.setProperty("HTTPSampler.protocol", (Object)this.protocol.getText());
        element.setProperty("HTTPSampler.method", (Object)(this.post.isSelected() ? "POST" : "GET"));
        element.setProperty("HTTPSampler.path", (Object)this.path.getText());
        element.setProperty("HTTPSampler.follow_redirects", (Object)new Boolean(this.followRedirects.isSelected()));
        element.setProperty("HTTPSampler.use_keepalive", (Object)new Boolean(this.useKeepAlive.isSelected()));
        return element;
    }

    public void configureSampler(HTTPSampler sampler) {
        sampler.setArguments((Arguments)this.argsPanel.createTestElement());
        sampler.setDomain(this.domain.getText());
        sampler.setProtocol(this.protocol.getText());
        sampler.setPath(this.path.getText());
        sampler.setFollowRedirects(this.followRedirects.isSelected());
        sampler.setUseKeepAlive(this.useKeepAlive.isSelected());
        if (this.port.getText().length() > 0) {
            sampler.setPort(Integer.parseInt(this.port.getText()));
        }
        sampler.setMethod(this.post.isSelected() ? "POST" : "GET");
    }

    public void configure(TestElement el) {
        this.setName((String)el.getProperty("TestElement.name"));
        this.argsPanel.configure((TestElement)el.getProperty("HTTPsampler.Arguments"));
        this.domain.setText((String)el.getProperty("HTTPSampler.domain"));
        this.port.setText(el.getPropertyAsString("HTTPSampler.port"));
        this.protocol.setText((String)el.getProperty("HTTPSampler.protocol"));
        if ("POST".equals(el.getProperty("HTTPSampler.method"))) {
            this.post.setSelected(true);
            this.get.setSelected(false);
        } else {
            this.get.setSelected(true);
            this.post.setSelected(false);
        }
        this.path.setText((String)el.getProperty("HTTPSampler.path"));
        this.followRedirects.setSelected(((AbstractTestElement)el).getPropertyAsBoolean("HTTPSampler.follow_redirects"));
        this.useKeepAlive.setSelected(((AbstractTestElement)el).getPropertyAsBoolean("HTTPSampler.use_keepalive"));
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        JPanel webServerPanel = new JPanel();
        webServerPanel.setLayout(new BorderLayout());
        webServerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"web_server")));
        webServerPanel.add((Component)this.getDomainPanel(), "North");
        webServerPanel.add((Component)this.getPortPanel(), "South");
        JPanel webRequestPanel = new JPanel();
        webRequestPanel.setLayout(new BorderLayout());
        webRequestPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"web_request")));
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)this.getProtocolAndMethodPanel(), "North");
        northPanel.add((Component)this.getPathPanel(), "South");
        webRequestPanel.add((Component)northPanel, "North");
        webRequestPanel.add((Component)this.getParameterPanel(), "Center");
        this.add((Component)webServerPanel, "North");
        this.add((Component)webRequestPanel, "Center");
    }

    protected JPanel getPortPanel() {
        JPanel portP = new JPanel(new FlowLayout(0));
        portP.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 10));
        portP.add(new JLabel(JMeterUtils.getResString((String)"web_server_port")));
        this.port = new JTextField(6);
        this.port.setName(PORT);
        portP.add(this.port);
        return portP;
    }

    protected JPanel getDomainPanel() {
        JPanel domainP = new JPanel(new FlowLayout(0));
        domainP.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 10));
        domainP.add(new JLabel(JMeterUtils.getResString((String)"web_server_domain")));
        this.domain = new JTextField(20);
        this.domain.setName(DOMAIN);
        domainP.add(this.domain);
        return domainP;
    }

    protected JPanel getPathPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 10));
        panel.add(new JLabel(JMeterUtils.getResString((String)"path")));
        this.path = new JTextField(15);
        this.path.setName(PATH);
        panel.add(this.path);
        this.followRedirects = new JCheckBox(JMeterUtils.getResString((String)"follow_redirects"));
        this.followRedirects.setName(FOLLOW_REDIRECTS);
        this.followRedirects.setSelected(true);
        panel.add(this.followRedirects);
        this.useKeepAlive = new JCheckBox(JMeterUtils.getResString((String)"use_keepalive"));
        this.useKeepAlive.setName(USE_KEEPALIVE);
        this.useKeepAlive.setSelected(true);
        panel.add(this.useKeepAlive);
        return panel;
    }

    protected JPanel getProtocolAndMethodPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 10));
        panel.add(new JLabel(JMeterUtils.getResString((String)"protocol")));
        this.protocol = new JTextField(4);
        this.protocol.setName(PROTOCOL);
        panel.add(this.protocol);
        this.post = new JRadioButton(JMeterUtils.getResString((String)"url_config_post"));
        this.get = new JRadioButton(JMeterUtils.getResString((String)"url_config_get"));
        ButtonGroup methodButtonGroup = new ButtonGroup();
        methodButtonGroup.add(this.post);
        methodButtonGroup.add(this.get);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(new JLabel(JMeterUtils.getResString((String)"method")));
        this.post.setSelected(true);
        panel.add(this.get);
        panel.add(this.post);
        return panel;
    }

    protected JPanel getParameterPanel() {
        this.argsPanel = new HTTPArgumentsPanel();
        return this.argsPanel;
    }
}

