/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import java.io.Serializable;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class Cookie
extends AbstractTestElement
implements Serializable {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.http");
    private static String NAME = "Cookie.name";
    private static String VALUE = "Cookie.value";
    private static String DOMAIN = "Cookie.domain";
    private static String EXPIRES = "Cookie.expires";
    private static String SECURE = "Cookie.secure";
    private static String PATH = "Cookie.path";

    public Cookie() {
        this.setName("");
        this.setValue("");
        this.setDomain("");
        this.setPath("");
        this.setSecure(false);
        this.setExpires(0L);
    }

    public Cookie(String name, String value, String domain, String path, boolean secure, long expires) {
        this.setName(name);
        this.setValue(value);
        this.setDomain(domain);
        this.setPath(path);
        this.setSecure(secure);
        this.setExpires(expires);
    }

    public void addConfigElement(ConfigElement config) {
    }

    public boolean expectsModification() {
        return false;
    }

    public String getClassLabel() {
        return "Cookie";
    }

    public String getValue() {
        return (String)this.getProperty(VALUE);
    }

    public synchronized void setValue(String value) {
        this.setProperty(VALUE, value);
    }

    public String getDomain() {
        return (String)this.getProperty(DOMAIN);
    }

    public synchronized void setDomain(String domain) {
        this.setProperty(DOMAIN, domain);
    }

    public long getExpires() {
        Object ret = this.getProperty(EXPIRES);
        if (ret == null) {
            return 0L;
        }
        if (ret instanceof Long) {
            return (Long)ret;
        }
        if (ret instanceof String) {
            try {
                return Long.parseLong((String)ret);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }

    public synchronized void setExpires(long expires) {
        this.setProperty(EXPIRES, new Long(expires));
    }

    public boolean getSecure() {
        log.info("Secure = " + this.getProperty(SECURE));
        return this.getPropertyAsBoolean(SECURE);
    }

    public synchronized void setSecure(boolean secure) {
        this.setProperty(SECURE, new Boolean(secure));
    }

    public String getPath() {
        return (String)this.getProperty(PATH);
    }

    public synchronized void setPath(String path) {
        this.setProperty(PATH, path);
    }

    public String toString() {
        return this.getDomain() + "\tTRUE\t" + this.getPath() + "\t" + new Boolean(this.getSecure()).toString().toUpperCase() + "\t" + this.getExpires() + "\t" + this.getName() + "\t" + this.getValue();
    }
}

