/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.util.JMeterUtils;

public class HeaderManager
extends ConfigTestElement
implements Serializable {
    public static final String HEADERS = "HeaderManager.headers";
    private static final int columnCount = 2;
    private static final String[] columnNames;
    private static List addableList;

    public HeaderManager() {
        this.setProperty(HEADERS, new ArrayList());
    }

    public List getHeaders() {
        return (List)this.getProperty(HEADERS);
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int column) {
        return columnNames[column];
    }

    public Class getColumnClass(int column) {
        return columnNames[column].getClass();
    }

    public Header getHeader(int row) {
        return (Header)this.getHeaders().get(row);
    }

    public void save(String headFile) throws IOException {
        File file = new File(headFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.dir") + File.separator + headFile);
        }
        PrintWriter writer = new PrintWriter(new FileWriter(file));
        writer.println("# JMeter generated Header file");
        int i = 0;
        while (i < this.getHeaders().size()) {
            Header head = (Header)this.getHeaders().get(i);
            writer.println(head.toString());
            ++i;
        }
        writer.flush();
        writer.close();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addFile(String headerFile) throws IOException {
        String line;
        File file = new File(headerFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.dir") + File.separator + headerFile);
        }
        BufferedReader reader = null;
        if (!file.canRead()) {
            throw new IOException("The file you specified cannot be read.");
        }
        reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            void var4_4;
            try {
                if (var4_4.startsWith("#") || var4_4.trim().length() == 0) continue;
                String[] st = this.split((String)var4_4, "\t", " ");
                int name = 0;
                int value = 1;
                Header header = new Header(st[name], st[value]);
                this.getHeaders().add(header);
            }
            catch (Exception e) {
                throw new IOException("Error parsing header line\n\t'" + (String)var4_4 + "'\n\t" + e);
            }
        }
        reader.close();
    }

    public void add(Header h) {
        this.getHeaders().add(h);
    }

    public void add() {
        this.getHeaders().add(new Header());
    }

    public void remove(int index) {
        this.getHeaders().remove(index);
    }

    public int size() {
        return this.getHeaders().size();
    }

    public Header get(int i) {
        return (Header)this.getHeaders().get(i);
    }

    public void removeHeaderNamed(String name) {
        Vector<Integer> removeIndices = new Vector<Integer>();
        int i = this.getHeaders().size() - 1;
        while (i > 0) {
            Header header = (Header)this.getHeaders().get(i);
            if (header != null && header.getName().equalsIgnoreCase(name)) {
                removeIndices.addElement(new Integer(i));
            }
            --i;
        }
        Enumeration e = removeIndices.elements();
        while (e.hasMoreElements()) {
            this.getHeaders().remove((Integer)e.nextElement());
        }
    }

    /*
     * Unable to fully structure code
     */
    public String[] split(String splittee, String splitChar, String def) {
        if (splittee != null && splitChar != null) ** GOTO lbl4
        return new String[0];
lbl-1000:
        // 1 sources

        {
            splittee = splittee.substring(0, (int)(var6_4 + splitChar.length())) + def + splittee.substring((int)(var6_4 + 1 * splitChar.length()), splittee.length());
lbl4:
            // 2 sources

            ** while ((spot = splittee.indexOf((String)(splitChar + splitChar))) != -1)
        }
lbl5:
        // 1 sources

        returns = new Vector<String>();
        tokens = new StringTokenizer(splittee, splitChar);
        while (tokens.hasMoreTokens()) {
            temp = tokens.nextToken();
            returns.addElement(temp);
        }
        values = new String[returns.size()];
        returns.copyInto(values);
        return values;
    }

    public String getClassLabel() {
        return JMeterUtils.getResString((String)"header_manager_title");
    }

    static {
        HEADERS = HEADERS;
        columnCount = 2;
        columnNames = new String[]{JMeterUtils.getResString((String)"name"), JMeterUtils.getResString((String)"value")};
        addableList = new LinkedList();
    }
}

