/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.protocol.http.config.gui.MultipartUrlConfigGui;
import org.apache.jmeter.protocol.http.config.gui.UrlConfigGui;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerFull;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class HttpTestSampleGui
extends AbstractSamplerGui {
    private UrlConfigGui urlConfigGui;
    private JCheckBox getImages;

    public HttpTestSampleGui() {
        this.init();
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.urlConfigGui.configure(element);
        String testClass = (String)element.getProperty("TestElement.test_class");
        if (testClass != null && testClass.endsWith("Full")) {
            this.getImages.setSelected(true);
        } else {
            this.getImages.setSelected(false);
        }
    }

    public TestElement createTestElement() {
        TestElement el = this.urlConfigGui.createTestElement();
        HTTPSampler sampler = this.getImages.isSelected() ? new HTTPSamplerFull() : new HTTPSampler();
        sampler.addTestElement(el);
        this.configureTestElement((TestElement)sampler);
        return sampler;
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"web_testing_title");
    }

    private void init() {
        this.setLayout(new GridLayout(1, 1));
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout(new BorderLayout());
        JPanel titlePanel = new JPanel(new BorderLayout());
        JLabel panelTitleLabel = new JLabel(JMeterUtils.getResString((String)"web_testing_title"));
        Font curFont = panelTitleLabel.getFont();
        int curFontSize = curFont.getSize();
        panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
        titlePanel.add((Component)panelTitleLabel, "North");
        titlePanel.add((Component)this.getNamePanel(), "South");
        mainPanel.add((Component)titlePanel, "North");
        this.urlConfigGui = new MultipartUrlConfigGui();
        mainPanel.add((Component)this.urlConfigGui, "Center");
        mainPanel.add((Component)this.createOptionalTasksPanel(), "South");
        this.add(mainPanel);
    }

    private JPanel createOptionalTasksPanel() {
        JPanel optionalTasksPanel = new JPanel();
        optionalTasksPanel.setLayout((LayoutManager)new VerticalLayout(5, 2, 1));
        optionalTasksPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"optional_tasks")));
        JPanel retrieveImagesPanel = new JPanel();
        retrieveImagesPanel.setLayout(new BoxLayout(retrieveImagesPanel, 0));
        retrieveImagesPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.getImages = new JCheckBox(JMeterUtils.getResString((String)"web_testing_retrieve_images"));
        retrieveImagesPanel.add(this.getImages);
        optionalTasksPanel.add(retrieveImagesPanel);
        return optionalTasksPanel;
    }
}

